<?php
namespace Drupal\basket\Admin\Page;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use Drupal\Core\Url;

class Orders{
	
	protected static $Basket;
	protected static $getTotalSum;

	public static function page(){
		if(!self::$Basket){
			self::$Basket = \Drupal::service('Basket');
		}
		return [
			'statistics'	=> self::$Basket->full('getStatisticsBlock', [TRUE]),
			'orders'		=> [
				'#prefix'		=> '<div class="basket_table_wrap">',
				'#suffix'		=> '</div>',
				'title'			=> [
					'#prefix'		=> '<div class="b_title">',
					'#suffix'		=> '</div>',
					'#markup'		=> self::$Basket->Translate()->t('Orders')
				],
				'content'		=> [
					'#prefix'		=> '<div class="b_content">',
					'#suffix'		=> '</div>',
					'view'			=> self::$Basket->getView('basket', 'block_1', 'not_delete'),
					'color'			=> [
						'#prefix'		=> '<div class="basket_color_info">',
						'#suffix'		=> '</div>',
						'info'			=> self::$Basket->textColor(self::$Basket->Translate()->t('Order not yet reviewed'), '#00A337')
					]
				]
			]
		];
	}
	public static function ApiResponseAlter($response, $api_type = NULL){
		switch($api_type){
			case'orders_stat_block_settings':
				\Drupal::service('BasketPopup')->openModal(
		            $response,
		            \Drupal::service('Basket')->Translate()->t('Order statistics block settings'),
		            \Drupal::formBuilder()->getForm(new BasketOrdersStatBlockSettings()),
		            [
		                'width' => 600,
		                'class' => []
		            ]
		        );
			break;
			case'orders_tabs_settings':
				\Drupal::service('BasketPopup')->openModal(
		            $response,
		            \Drupal::service('Basket')->Translate()->t('Tab setting'),
		            \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\OrdersTabsSettingsForm'),
		            [
		                'width' 	=> 960,
		                'class' 	=> []
		            ]
		        );
			break;
		}
	}
}

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class BasketOrdersStatBlockSettings extends FormBase{
	protected static $Basket;
    public function __construct(){
        self::$Basket = \Drupal::service('Basket');
    }
	public function getFormId(){
        return 'basket_orders_stat_block_settings_form';
    }
    public function buildForm(array $form, FormStateInterface $form_state){
    	$form += [
    		'#prefix'		=> '<div id="basket_orders_stat_block_settings_form_ajax_wrap">',
    		'#suffix'		=> '</div>',
    		'#attached'		=> [
    			'library'		=> [
    				'basket/colorpicker'
    			]
    		],
    		'config'		=> [
    			'#tree'			=> TRUE,
    		]
    	];
    	foreach ([
    		'processed'		=> [
    			'title'			=> 'Orders are being processed',
    			'status'		=> TRUE
    		],
    		'completed'		=> [
    			'title'			=> 'Completed orders',
    			'status'		=> TRUE
    		],
    		'return'		=> [
    			'title'			=> 'Purchase returns',
    			'status'		=> TRUE
    		],
    		'total'			=> [
    			'title'			=> 'Total amount of orders'
    		]
    	] as $key => $info){
    		$title = self::$Basket->getSettings('orders_stat_block_settings', 'config.'.$key.'.title');
    		$title = !empty($title) ? trim($title) : $info['title'];
    		$form['config'][$key] = [
    			'#type'			=> 'details',
    			'#title'		=> self::$Basket->Translate()->t($title),
    			'title'			=> [
    				'#type'			=> 'textfield',
    				'#title'		=>self::$Basket->Translate()->t('Title'),
    				'#required'		=> TRUE,
    				'#default_value'=> $title
    			],
    			'on'			=> [
    				'#type'			=> 'checkbox',
					'#title'		=> self::$Basket->Translate()->t('Active'),
					'#default_value'=> self::$Basket->getSettings('orders_stat_block_settings', 'config.'.$key.'.on')
    			],
    			'color'			=> [
    				'#type'			=> 'textfield',
					'#title'		=> self::$Basket->Translate()->t('Color').':',
					'#attributes'   => [
		                'readonly'      => 'readonly',
		                'class'         => ['color_input']
		            ],
		            '#states'		=> [
						'visible'		=> [
							'input[name="config['.$key.'][on]"]' => ['checked' => TRUE]
						]
					],
		            '#default_value'=> self::$Basket->getSettings('orders_stat_block_settings', 'config.'.$key.'.color')
    			]
    		];
    		if(!empty($info['status'])){
    			$form['config'][$key]['status'] = [
    				'#type'			=> 'checkboxes',
					'#title'		=> self::$Basket->Translate()->t('Order status').':',
					'#options'		=> self::$Basket->Term()->getOptions('status'),
					'#states'		=> [
						'visible'		=> [
							'input[name="config['.$key.'][on]"]' => ['checked' => TRUE]
						]
					],
		            '#default_value'=> self::$Basket->getSettings('orders_stat_block_settings', 'config.'.$key.'.status')
    			];
    		}
    	}

    	$form['actions'] = [
            '#type'         => 'actions',
            'submit'        => [
                '#type'         => 'submit',
                '#value'        => self::$Basket->Translate()->t('Save'),
                '#ajax'         => [
                    'wrapper'       => 'basket_orders_stat_block_settings_form_ajax_wrap',
                    'callback'      => [$this, 'ajaxSubmit']
                ]
            ]
        ];
    	return $form;
    }
    public function submitForm(array &$form, FormStateInterface $form_state){
    	self::$Basket->setSettings('orders_stat_block_settings', 'config', $form_state->getValue('config'));
    }
    public function ajaxSubmit(array &$form, FormStateInterface $form_state){
        $response = new AjaxResponse();
        $response->addCommand(new InvokeCommand(NULL, 'NotyGenerate', ['status', self::$Basket->Translate()->t('Settings saved.')]));
        $response->addCommand(new InvokeCommand('body', 'append', ['<script>location.reload();</script>']));
        return $response;
    }
}