<?php
namespace Drupal\basket\Admin\Page;

use Drupal\views\Views;
use Drupal\Core\Url;

class Trash{
	
	protected static $Basket;

	function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	/*
	 page
	*/
	public function page(){
		return [
			'orders'		=> [
				'#prefix'		=> '<div class="basket_table_wrap trash_page">',
				'#suffix'		=> '</div>',
				'title'			=> [
					'#prefix'		=> '<div class="b_title">',
					'#suffix'		=> '</div>',
					'#markup'		=> self::$Basket->Translate()->t('Trash can').' "'.self::$Basket->Translate()->t('Orders').'"'
				],
				'content'		=> [
					'#prefix'		=> '<div class="b_content">',
					'#suffix'		=> '</div>',
					'view'			=> self::$Basket->getView('basket', 'block_1', 'is_delete')
				]
			],
			'nodes'			=> [
				'#prefix'		=> '<div class="basket_table_wrap trash_page">',
				'#suffix'		=> '</div>',
				'title'			=> [
					'#prefix'		=> '<div class="b_title">',
					'#suffix'		=> '</div>',
					'#markup'		=> self::$Basket->Translate()->t('Trash can').' "'.self::$Basket->Translate()->t('Product').'"'
				],
				'content'		=> [
					'#prefix'		=> '<div class="b_content">',
					'#suffix'		=> '</div>',
					'view'			=> self::$Basket->getView('basket', 'block_3', 'is_delete')
				]
			]
		];
	}
	/*
	 getCaptionItems
	*/
	public function getCaptionItems($type = 'orders'){
		$items = [];
		if(\Drupal::currentUser()->hasPermission('basket access_restore_'.$type)){
			$items[] = [
				'name'			=> self::$Basket->Translate()->t('Restore all '.$type),
				'url'			=> Url::fromRoute('basket.admin.pages', ['page_type'		=> 'trash-restore-'.$type])->toString(),
			];
		}
		if(\Drupal::currentUser()->hasPermission('basket access_trash_clear_page')){
			$items[] = [
				'name'			=> self::$Basket->Translate()->t('Delete all '.$type),
				'url'			=> Url::fromRoute('basket.admin.pages', ['page_type'		=> 'trash-delete-'.$type])->toString(),
			];
		}
		return $items;
	}
	/*
	 restoreBath
	*/
	public function restoreBath($type){
		if(!\Drupal::currentUser()->hasPermission('basket access_restore_order')){
			return \Drupal::service('Basket')->getError(403);
		}
		$bathTitle = NULL;
		switch($type){
			case'orders':
				if(!empty(Views::getEnabledViews()['basket'])){
		            $view = Views::getView('basket');
		            $view->setItemsPerPage(0);
		            $view->executeDisplay('block_1', ['is_delete']);
		            if(!empty($view->result)){
		                foreach ($view->result as $row){
		                    if(empty($row->basket_orders_id)) continue;
		                    $operations[] = ['\\'.__CLASS__.'::restoreOrderProcess', [$row->basket_orders_id]];
		                }
		            }
		        }
				$bathTitle = \Drupal::service('Basket')->Translate()->t('Recover deleted orders');
			break;
			case'products':
				$operations[] = ['\\'.__CLASS__.'::restoreProductsProcess', []];
				$bathTitle = \Drupal::service('Basket')->Translate()->t('Recover deleted products');
			break;
		}
        if(!empty($operations)){
            $batch = array(
                'title'             => $bathTitle,
                'operations'        => $operations,
                'basket_batch'      => TRUE
            );
            batch_set($batch);
            $response = batch_process(Url::fromRoute('basket.admin.pages', ['page_type' => 'trash'])->toString());
            $response->send();
        } else {
            return \Drupal::service('Basket')->getError(404);
        }
	}
	public static function restoreOrderProcess($orderId, &$context){
		$Order = \Drupal::service('Basket')->Orders($orderId);
		$Order->set('is_delete', NULL);
		$Order->save();
	}
	public static function restoreProductsProcess(){
		\Drupal::database()->truncate('basket_node_delete')->execute();;
	}
	/*
	 deleteBath
	*/
	public function deleteBath($type){
	 	if(!\Drupal::currentUser()->hasPermission('basket access_trash_clear_page')){
			return \Drupal::service('Basket')->getError(403);
		}
		$bathTitle = NULL;
		switch($type){
			case'orders':
				if(!empty(Views::getEnabledViews()['basket'])){
		            $view = Views::getView('basket');
		            $view->setItemsPerPage(0);
		            $view->executeDisplay('block_1', ['is_delete']);
		            if(!empty($view->result)){
		                foreach ($view->result as $row){
		                    if(empty($row->basket_orders_id)) continue;
		                    $operations[] = ['\\'.__CLASS__.'::deleteOrderProcess', [$row->basket_orders_id]];
		                }
		            }
		        }
				$bathTitle = \Drupal::service('Basket')->Translate()->t('Irreversible order removal');
		        if(!empty($operations)){
		        	return [
		        		'#prefix'		=> '<div class="basket_table_wrap">',
		        		'#suffix'		=> '</div>',
		        		[
		        			'#prefix'		=> '<div class="b_title">',
		        			'#suffix'		=> '</div>',
		        			'#markup'		=> self::$Basket->Translate()->t('Confirm removal')
		        		],[
		        			'#prefix'		=> '<div class="b_content">',
		        			'#suffix'		=> '</div>',
		        			'form'			=> \Drupal::formBuilder()->getForm(new TrashConfirmDelete($operations, $bathTitle))
		        		]
		        	];
		        } else {
		            return \Drupal::service('Basket')->getError(404);
		        }
			break;
			case'products':
				$bathTitle = \Drupal::service('Basket')->Translate()->t('Irreversible products removal');
				// ---
				$nids = \Drupal::database()->select('basket_node_delete', 'n')
									->fields('n', ['nid'])
									->execute()->fetchCol();
				if(!empty($nids)){
					foreach ($nids as $nid) {
						$operations[] = ['\\'.__CLASS__.'::deleteProductProcess', [$nid]];
					}
				}
				// ---
				if(!empty($operations)){
		        	return [
		        		'#prefix'		=> '<div class="basket_table_wrap">',
		        		'#suffix'		=> '</div>',
		        		[
		        			'#prefix'		=> '<div class="b_title">',
		        			'#suffix'		=> '</div>',
		        			'#markup'		=> self::$Basket->Translate()->t('Confirm removal')
		        		],[
		        			'#prefix'		=> '<div class="b_content">',
		        			'#suffix'		=> '</div>',
		        			'form'			=> \Drupal::formBuilder()->getForm(new TrashConfirmDelete($operations, $bathTitle))
		        		]
		        	];
		        } else {
		            return \Drupal::service('Basket')->getError(404);
		        }
			break;
		}
	}
	public static function deleteOrderProcess($orderId, &$context){
		$Order = \Drupal::service('Basket')->Orders($orderId);
		$Order->delete();
	}
	public static function deleteProductProcess($nid){
		$entity = \Drupal::entityTypeManager()->getStorage('node')->load($nid);
		if(!empty($entity)){
			$entity->delete();
		}
	}
}

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class TrashConfirmDelete extends FormBase{

	protected static $operations;
	protected static $bathTitle;
	protected static $Basket;

	function __construct($operations, $bathTitle){
		self::$operations = $operations;
		self::$bathTitle = $bathTitle;
		self::$Basket = \Drupal::service('Basket');
	}

	public function getFormId(){
        return 'basket_trash_confirm_delete_form';
    }
    public function buildForm(array $form, FormStateInterface $form_state){
    	$form['text'] = [
    		'#markup'		=> self::$Basket->Translate()->t('This action is irreversible!')
    	];
    	$form['actions'] = [
    		'#type'			=> 'actions',
    		'submit'		=> [
    			'#type'			=> 'submit',
    			'#value'		=> self::$Basket->Translate()->t('Delete'),
    			'#attributes'	=> [
    				'class'			=> ['button--delete']
    			]
    		],
    		'cancel'		=> [
    			'#type'			=> 'inline_template',
    			'#template'		=> '<a href="javascript:history.back();" class="form-submit">{{ text }}</a>',
    			'#context'		=> [
    				'text'			=> self::$Basket->Translate()->t('Cancel')
    			]
    		]
    	];
    	return $form;
    }
    public function submitForm(array &$form, FormStateInterface $form_state){
    	$form_state->setRedirect('basket.admin.pages', ['page_type' => 'trash']);
    	$batch = array(
            'title'             => self::$bathTitle,
            'operations'        => self::$operations,
            'basket_batch'      => TRUE
        );
        batch_set($batch);
    }
}