<?php

namespace Drupal\basket;
use Drupal\Core\Url;

class BasketTranslate{

    protected static $isTranslate;
    protected $contextModule;

    function __construct($contextModule = 'basket'){
        $this->contextModule = $contextModule;
    }

  	public function title(array $_title_arguments = array(), $_title = ''){
  		return self::t($_title);
  	}
    public function t($text, $args = [], $options = []){
        $options['context'] = $this->contextModule;
        return t(trim($text), $args, $options);
    }
    public static function isEnabled(){
    	if(!isset(self::$isTranslate)){
            self::$isTranslate = \Drupal::database()->schema()->tableExists('locales_source');
    	}
    	return self::$isTranslate;
    }
    public function getTranslateLink($text){
    	if(self::isEnabled()){
    		return [
    			'#type'		=> 'inline_template',
    			'#template'	=> '<a href="javascript:void(0);" onclick="{{onclick}}" data-post="{{post}}" title="{{title}}">{{ico|raw}}</a>',
    			'#context'	=> [
                    'title'         => $this->t('Translation'),
    				'onclick'       => 'basket_admin_ajax_link(this, \''.Url::fromRoute('basket.admin.pages', [
    					'page_type' 	=> 'api-translation_popup'
    				],[
    					'query'			=> [
    						'string'	=> $text
    					]
    				])->toString().'\')',
                    'ico'           => \Drupal::service('Basket')->getIco('google.svg', 'base')
    			]
    		];
    	}
    }
}