<?php

namespace Drupal\basket\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Url;
/**
 *
 * @Block(
 *   id = "basket_currency",
 *   admin_label = "Basket currency",
 *   category = "Basket currency",
 * )
 */
class BasketCurrencyBlock extends BlockBase{

	protected $basket;

	public function __construct(){
		$this->basket = \Drupal::service('Basket');
	}

	public function build() {
	    return [
	    	[
	    		'#type'			=> 'select',
	    		'#options'		=> $this->basket->Currency()->getOptions(TRUE),
	    		'#value'		=> $this->basket->Currency()->getCurrent(),
	    		'#attributes'	=> [
	    			'onchange'		=> 'basket_ajax_link(this, \''.Url::fromRoute('basket.pages', ['page_type' => 'api-change_currency'])->toString().'\')',
	    			'data-post'		=> json_encode([
	    				'post_type'		=> 'change_currency'
	    			])
	    		],
	    		'#attached'		=> [
	    			'library'		=> [
	    				'basket/basket.js'
	    			]
	    		]
	    	],
	    	'#cache'		=> [
	    		'max-age'		=> 0
	    	]
	    ];
	}
}