<?php

namespace Drupal\basket\Plugin\views\area;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\style\DefaultSummary;
use \Drupal\views\Plugin\views\area\AreaPluginBase;

/**
 * Views area handler to display some configurable result summary.
 *
 * @ingroup views_area_handlers
 *
 * @ViewsArea("basket_cart_result")
 */
class BasketCartResult extends AreaPluginBase {

  protected $basket;
  protected $basketDelivery;

  public function __construct(){
    $this->basket = \Drupal::service('Basket');
    $this->basketDelivery = \Drupal::service('BasketDelivery');
  }

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    
  }

  /**
   * {@inheritdoc}
   */
  public function render($empty = FALSE){
    return [
      '#theme'        => 'basket_views_cart_data',
      '#info'         => [
        'Cart'          => $this->basket->Cart(),
        'view'          => $this->view,
        'delivery'      => $this->basketDelivery->getDeliveryInfo()
      ]
    ];
  }
}