<?php
/**
 * @ViewsField("basket_order_currency")
 */

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

class BasketOrderCurrency extends FieldPluginBase{

	protected $basket;

    public function __construct(){
        call_user_func_array(array('parent', '__construct'), func_get_args());
        $this->basket = \Drupal::service('Basket');
    }

    public function render(ResultRow $values){
        $currency = $this->basket->Currency()->load($this->getValue($values));
        if(!empty($currency->name)){
            return $this->basket->Translate()->t($currency->name);
        }
        return $this->getValue($values);
    }
}