<?php
/**
 * @ViewsField("basket_order_term")
 */

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Drupal\views\ViewExecutable;
use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class BasketOrderTerm extends FieldPluginBase{
   
    protected $basket;
    
    public function init(ViewExecutable $view, DisplayPluginBase $display, array &$options = NULL){
        parent::init($view, $display, $options);
        $this->basket = \Drupal::service('Basket');
    }
    protected function defineOptions() {
        $options = parent::defineOptions();
        $options['change'] = ['default' => 0];
        return $options;
    }
    public function buildOptionsForm(&$form, FormStateInterface $form_state) {
        $form['change'] = [
            '#type'         => 'checkbox',
            '#title'        => $this->t('Change ajax'),
            '#default_value'=> $this->options['change']
        ];
        parent::buildOptionsForm($form, $form_state);
    }
    public function render(ResultRow $values){
        $term = $this->basket->Term()->load($this->getValue($values));
    	if(!empty($term)){
            if($this->view->id() == 'basket'){
                return $this->getNameHtml(
                    $term, 
                    $this->realField,
                    $this->getValue($values),
                    $values,
                    $this->options['change']
                );
            } else {
                return $this->basket->Translate()->t($term->name);
            }
    	}
    	return $this->getValue($values);
    }
    private function getNameHtml($term, $realField, $def, $values, $ajaxChange = FALSE){
        switch($realField){
            case'status':
            case'fin_status':
                $active_html = $this->basket->textColor(
                    $this->basket->Translate()->t($term->name),
                    $term->color,
                    [
                        'class'     => ['status_'.$term->type.'_'.$values->basket_orders_id]
                    ]
                );
                if(empty($ajaxChange)){
                    return $active_html;
                }
                if(\Drupal::currentUser()->hasPermission('basket edit_'.$realField.'_order_access')){
                    $Order = $this->basket->Orders($values->basket_orders_id)->load();
                    if(!empty($Order->is_delete)){
                        return $active_html;
                    }
                    return [
                        'view'          => $active_html,
                        'select'        => [
                            '#type'         => 'select',
                            '#options'      => $this->basket->Term()->getOptions($term->type),
                            '#attributes'   => [
                                'class'         => ['term_change_select'],
                                'onchange'      => 'basket_admin_ajax_link(this, \''.Url::fromRoute('basket.admin.pages', [
                                    'page_type'     => 'api-order_change_status'
                                ])->toString().'\')',
                                'data-post'     => json_encode([
                                    'orderID'       => $values->basket_orders_id,
                                    'status_type'   => $term->type,
                                    'set_val'       => $term->id
                                ])
                            ],
                            '#field_suffix' => ' ',
                            '#value'        => $term->id
                        ]
                    ];
                } else {
                    return $active_html;
                }
            break;
            default:
                return self::$Basket->Translate()->t($term->name);
            break;
        }
        return [];
    }
}