<?php

namespace Drupal\basket\Plugin\views\filter;

use \Drupal\views\Plugin\views\filter\FilterPluginBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views\ViewExecutable;
use Drupal\views\Plugin\views\display\DisplayPluginBase;

/**
 * Default implementation of the base filter plugin.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("basket_goods_filter_block2")
 */
class BasketGoodsFilterBlock2 extends FilterPluginBase {
	
	protected $basket;
	protected $request;

	public function init(ViewExecutable $view, DisplayPluginBase $display, array &$options = NULL){
        parent::init($view, $display, $options);
        $this->basket = \Drupal::service('Basket');
		$this->request = \Drupal::request()->request->all();
    }
	public function buildExposedForm(&$form, FormStateInterface $form_state){
		$form['orderId'] = [
			'#type'			=> 'hidden',
			'#value'		=> !empty($this->request['orderId']) ? $this->request['orderId'] : ''
		];
	}
	public function acceptExposedInput($input){
		$accept = FALSE;
		if(!empty($this->request['orderId'])){
			$accept = TRUE;
		}
		return $accept;
	}
	public function query(){
		$this->ensureMyTable();
		$nodeTypes = [0];
		if(!empty($SettingsNodeTypes = $this->basket->getNodeTypes())){
			foreach ($SettingsNodeTypes as $info){
				$nodeTypes[] = $info->type;
			}
		}
		$this->query->addWhere(1,'node_field_data.type', $nodeTypes, 'IN');
	}
	public function adminSummary(){
		return 'Basket goods filter block 2';
	}
}