<?php

namespace Drupal\basket;
use Drupal\Core\Render\Markup;

class Requirements{
	public function info(&$requirements){
		$severity = REQUIREMENT_OK;
		$moduleInfo = \Drupal::service('extension.list.module')->getExtensionInfo('basket');
		$items = [];
        /*Mpdf*/
		if(class_exists('Mpdf\Mpdf')){
			$items[] = 'Mpdf: '.t('Installed');
		} else {
			$severity = REQUIREMENT_WARNING;
			$items[] = Markup::create('Mpdf: '.t('Not installed').'. <a href="https://packagist.org/packages/mpdf/mpdf" target="_blank">'.t('Install').'</a>');
		}
		/*PhpSpreadsheet*/
		if(class_exists('PhpOffice\PhpSpreadsheet\Spreadsheet')){
			$items[] = 'PhpSpreadsheet: '.t('Installed');
		} else {
			$severity = REQUIREMENT_WARNING;
			$items[] = Markup::create('PhpSpreadsheet: '.t('Not installed').'. <a href="https://phpspreadsheet.readthedocs.io" target="_blank">'.t('Install').'</a>');
		}
		/**/
		$requirements['basket'] = [
			'title'			=> 'Basket',
			'value' 		=> !empty($moduleInfo['version']) ? $moduleInfo['version'] : NULL,
			'severity'		=> $severity,
			'description'	=> [
				'#theme'		=> 'item_list',
				'#items'		=> $items
			]
		];
	}
}