<?php

namespace Drupal\basket;

class UserAdminPermissions{
	public static function formAlter(&$form, $form_state){
		$Basket = \Drupal::service('Basket');
		// ---
		$providerList = ['basket'];
        /*Alter*/
        \Drupal::moduleHandler()->alter('basket_translate_context', $providerList);
        /*END alter*/
        $permissions = \Drupal::service('user.permissions')->getPermissions();
        $permissions_by_provider = [];
        foreach ($permissions as $permission_name => $permission) {
            if(!in_array($permission['provider'], $providerList)) continue;
            $permissions_by_provider[$permission['provider']][$permission_name] = $permission;
        }
        foreach ($permissions_by_provider as $provider => $permissions){
        	foreach ($permissions as $perm => $perm_item) {
        		if(empty($form['permissions'][$perm])) continue;
        		$form['permissions'][$perm]['description'] = [
        			'#type'             => 'inline_template',
                    '#template'         => '<div class="permission"><span class="title">{{ title }}</span>{% if sub_title %} "{{ sub_title }}"{% endif %}</div>',
                    '#context'          => [
                        'title'             => $Basket->Translate($provider)->t(trim($perm_item['title'])),
                        'sub_title'         => !empty($perm_item['sub_title']) ? $Basket->Translate($provider)->t(trim($perm_item['sub_title'])) : NULL
                    ],
        		];
        	}
        }
	}
}