(function ($) {
	Drupal.behaviors.NPAdmin = {
		attach: function (context, settings){
			$('[data-mask]').once('mask').each(function(){
				Inputmask({
					"mask": $(this).data('mask'),
					'clearIncomplete': true
				}).mask($(this));
			});
			if(drupalSettings.npPostUpdate){
				$('.novaposhta_en_view a').trigger('click');
				delete drupalSettings.npPostUpdate;
			}
			$('.chosen_np_select').once('chosen_np_select').each(function(){
				$(this).chosen({
					no_results_text: drupalSettings.no_results_text
				});
			});
			if ($('.chosen-container').length > 0) {
		      	$('.chosen-container').on('touchstart', function(e){
		        	e.stopPropagation(); e.preventDefault();
		        	// Trigger the mousedown event.
		        	$(this).trigger('mousedown');
		      	});
		    }
		    $('.select2_np_select').once('select2_np_select').each(function(){
  				var obj = $(this);
				obj.select2({
					minimumResultsForSearch: 20,
				    dropdownAutoWidth : true,
				    width: '100%',
				    placeholder: obj.find('option').eq(0).text(),
				    language: {
				      	noResults: function () {
				        	return drupalSettings.no_results_text;
				      	},
				    },
				    matcher: function (params, data){
				    	if ($.trim(params.term) === '') {
					      	return data;
					    }
					    if (typeof data.text === 'undefined') {
					      	return null;
					    }
					    var text = data.text.toLowerCase()
					    if (text.indexOf(params.term.toLowerCase()) > -1) {
					      	return data;
					    }
					    return null;
				    },
				    sorter: function(data){
				    	var value = $('.select2-search input').val();
				    	return data.sort(function(a, b) {
				      		if (value && a.text.toLowerCase().startsWith(value.toLowerCase())) {
				        		return -1;
				      		}
				      		a.text.localeCompare(b.text);
				    	});
				    },
				});
			});
		}
	}
})(jQuery);