<?php

/**
 * @file
 * Provide views data for dblog.module.
 */

/**
 * Implements hook_views_data().
 */
function novaposhta_views_data() {
    $NovaPoshta = \Drupal::service('NovaPoshta');
    $data = [];

    $data['novaposhta_en']['table']['group'] = t('Novaposhta');
    $data['novaposhta_en']['table']['wizard_id'] = 'novaposhta_en';

    $data['novaposhta_en']['table']['base'] = [
        'field'     => 'id',
        'title'     => t('ID EN'),
        'help'      => '',
    ];
    foreach ([
        'id'            => [
            'title'         => $NovaPoshta->t('ID'),
            'field_id'      => 'standard',
            'sort_id'       => 'standard',
        ],
        'created'       => [
            'title'         => $NovaPoshta->t('Time to create invoice'),
            'field_id'      => 'date',
            'sort_id'       => 'date',
            'filter_id'     => 'date',
            'filter_id'     => 'novaposhta_en_date',
        ],
        'en_num'        => [
            'title'         => $NovaPoshta->t('Invoice number'),
            'field_id'      => 'standard',
            'sort_id'       => 'standard',
            'filter_id'     => 'string',
        ],
        'delivery_day'  => [
            'title'         => $NovaPoshta->t('Estimated delivery date'),
            'field_id'      => 'date',
            'sort_id'       => 'date',
            'filter_id'     => 'novaposhta_en_date',
        ],
        'cost'          => [
            'title'         => $NovaPoshta->t('Announced price'),
            'field_id'      => 'novaposhta_en_cost',
            'sort_id'       => 'standard',
        ],
        'cost_delivery' => [
            'title'         => $NovaPoshta->t('Shipping cost'),
            'field_id'      => 'novaposhta_en_cost',
            'sort_id'       => 'standard',
        ],
        'weight'        => [
            'title'         => $NovaPoshta->t('Weight'),
            'field_id'      => 'novaposhta_en_weight',
            'sort_id'       => 'standard',
        ],
        'seats_amount'  => [
            'title'         => $NovaPoshta->t('Number of places of departure'),
            'field_id'      => 'standard',
            'sort_id'       => 'standard',
        ],
        'description'  => [
            'title'         => $NovaPoshta->t('Description of departure'),
            'field_id'      => 'standard',
            'sort_id'       => 'standard',
        ],
        'address'       => [
            'title'         => $NovaPoshta->t('Receive address'),
            'field_id'      => 'novaposhta_en_address',
            'sort_id'       => 'standard',
        ],
        'status'        => [
            'title'         => $NovaPoshta->t('Status'),
            'field_id'      => 'standard',
            'sort_id'       => 'standard',
        ],
        'date_receiving'=> [
            'title'         => $NovaPoshta->t('Date of receiving'),
            'field_id'      => 'date',
            'sort_id'       => 'date',
        ]
    ] as $fieldName => $field) {
        $data['novaposhta_en'][$fieldName] = [
            'title'             => $field['title'],
            'help'              => ''
        ];
        if(!empty($field['field_id']))      $data['novaposhta_en'][$fieldName]['field']['id'] = $field['field_id'];
        if(!empty($field['sort_id']))       $data['novaposhta_en'][$fieldName]['sort']['id'] = $field['sort_id'];
        if(!empty($field['filter_id']))     $data['novaposhta_en'][$fieldName]['filter']['id'] = $field['filter_id'];
    }
    return $data;
}
/**
 * Implements hook_views_data_alter().
 */
function novaposhta_views_data_alter(array &$data){
    $NovaPoshta = \Drupal::service('NovaPoshta');
    $data['novaposhta_en']['settings'] = array(
        'title'         => $NovaPoshta->t('Settings'),
        'field'         => [
            'title'         => $NovaPoshta->t('Settings'),
            'help'          => '',
            'id'            => 'novaposhta_en_settings',
            'click sortable'=> FALSE,
        ]
    );
}