<?php

namespace Drupal\basket_paypal\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Drupal\Core\Url;
use PayPalCheckoutSdk\Orders\OrdersCreateRequest;

class PaymentForm extends FormBase{
  	
  /**
   * Drupal\basket_paypal\PayPal definition.
   *
   * @var \Drupal\basket_paypal\PayPal
   */
  protected $payPal;

  function __construct(){
    $this->payPal = \Drupal::getContainer()->get('PayPal');
  }

  public function getFormId(){
  	return 'basket_paypal_payment_form';
	}

	public function buildForm(array $form, FormStateInterface $form_state, $payment = []){
    if(empty($payment)){
      throw new NotFoundHttpException();
    }
    $form['#id'] = 'payment_form';
    $form['#attached']['library'][] = 'basket_paypal/css';
    $form['info'] = [
      '#type'         => 'inline_template',
      '#template'     => '<div class="sum"><label>{{ label }}:</label> {{ sum }} {{ currency }}</div>',
      '#context'      => [
        'label'         => $this->payPal->t('Sum'),
      ]
    ];
    $form['actions'] = [
      '#type'         => 'actions',
      'submit'        => [
        '#type'         => 'submit',
        '#value'        => $this->payPal->t('Pay')
      ]
    ];
    // ---
    $payment->result_url = Url::fromRoute('basket_paypal.pages', ['page_type' => 'result'],['absolute' => TRUE])->toString();
    $payment->cancel_url = Url::fromRoute('basket_paypal.pages', ['page_type' => 'cancel'],['absolute' => TRUE])->toString();
    // Payment alter
    $this->basketPaymentFormAlter($form, $form_state, $payment);
    // ---
    $form['info']['#context']['currency'] = $form['#params']['currency'];
    $form['info']['#context']['sum'] = $form['#params']['amount'];
  	return $form;
	}

	public function submitForm(array &$form, FormStateInterface $form_state) {}

  public function basketPaymentFormAlter(&$form, &$form_state, $payment) {
    
    $config = $this->payPal->getConfig();
    
    $form['#params'] = [
      'amount'        => $payment->amount,
      'currency'      => $payment->currency,
      'order_id'      => $payment->id.'-'.time().rand(0, 999),
      'result_url'    => $payment->result_url,
      'cancel_url'    => $payment->cancel_url,
    ];
    
    // Alter
    \Drupal::moduleHandler()->alter('basket_paypal_payment_params', $form['#params'], $payment, $config);
    
    $_SESSION['basket_paypal_last_pay'] = $payment->id;
    
    $client = $this->payPal->client($config);

    $request = new OrdersCreateRequest();
    $request->prefer('return=representation');
    $request->body = [
      'intent'          => 'CAPTURE',
      'purchase_units'  => [[
        'reference_id'    => $form['#params']['order_id'] ?? $payment->id(),
        'amount'          => [
          'value'           => $form['#params']['amount'] ?? 0,
          'currency_code'   => $form['#params']['currency'] ?? 'USD',
        ],
        'is_final_capture'    => TRUE,
      ]],
      'application_context' => [
        'cancel_url'          => $form['#params']['cancel_url'] ?? '',
        'return_url'          => $form['#params']['result_url'] ?? '',
      ]
    ];
    try {
      // Call API with your client and get a response for your call
      $response = $client->execute($request);
      if(!empty($response->result->links)) {
        foreach ($response->result->links as $link) {
          if($link->rel == 'approve') {
            $form['#action'] = $link->href;
          }
        }
      }
    }
    catch (\Exception $ex) {
      \Drupal::logger('BasketPayPal')->notice('<pre>'.print_r($ex->getMessage(), TRUE).'</pre>');
    }
  }

}
