<?php

namespace Drupal\basket_paypal;

use Drupal\Core\Database\Connection;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\SandboxEnvironment;
use PayPalCheckoutSdk\Core\ProductionEnvironment;

/**
 * Class PayPal.
 */
class PayPal {

  /**
   * Drupal\Core\Database\Driver\mysql\Connection definition.
   *
   * @var \Drupal\Core\Database\Driver\mysql\Connection
   */
  protected $database;

  /**
   * Constructs a new PayPal object.
   */
  public function __construct(Connection $database) {
    $this->database = $database;
  }

  /*
   * {@inheritdoc}
   */
  public function t($string, $args = []){
    return new TranslatableMarkup($string, $args, ['context' => 'basket_paypal']);
  }

  /*
   * {@inheritdoc}
   */
  public function load($params) {
    $query = $this->database->select('payments_basket_paypal', 'l');
    $query->fields('l');
    if(!empty($params['id'])) {
      $query->condition('l.id', $params['id']);
    }
    if(!empty($params['nid'])) {
      $query->condition('l.nid', $params['nid']);
    }
    if(!empty($params['sid'])) {
      $query->condition('l.sid', $params['sid']);
    }
    if(empty($params['data'])) {
      $params['data'] = [];
    }
    $payment = $query->execute()->fetchObject();
    // ---
    if(!empty($params['create_new'])) {
      $payment = FALSE;
    }
    if(empty($payment) && !empty($params['amount'])){
      $payment = (object)[
        'nid'       => !empty($params['nid']) ? $params['nid'] : NULL,
        'sid'       => !empty($params['sid']) ? $params['sid'] : NULL,
        'uid'       => \Drupal::currentUser()->id(),
        'created'   => time(),
        'paytime'   => NULL,
        'amount'    => $params['amount'],
        'currency'  => !empty($params['currency']) ? $params['currency'] : \Drupal::config('basket_paypal.settings')->get('config.currency'),
        'status'    => 'new',
        'data'      => serialize($params['data'])
      ];
      $payment->id = $this->database->insert('payments_basket_paypal')
        ->fields((array)$payment)
        ->execute();
    }
    return $payment;
  }

  /*
   * {@inheritdoc}
   */
  public function update($payment) {
    if(!empty($payment->id)){
      $updateFields = (array)$payment;
      unset($updateFields['id']);
      $this->database->update('payments_basket_paypal')
        ->fields($updateFields)
        ->condition('id', $payment->id)
        ->execute();
    }
  }

  /*
   * {@inheritdoc}
   */
  public function getConfig() {
    $config = \Drupal::config('basket_paypal.settings')->get('config');
    if(!empty($config['sandbox'])) {
      $config['clientId']     = $config['s_clientId'];
      $config['clientSecret'] = $config['s_clientSecret'];
    }
    return $config;
  }

  /*
   * {@inheritdoc}
   */
  public function client($config) {
    if(!empty($config['sandbox'])) {
      $environment = new SandboxEnvironment($config['clientId'], $config['clientSecret']);
    } else {
      $environment = new ProductionEnvironment($config['clientId'], $config['clientSecret']);
    }
    return new PayPalHttpClient($environment);
  }

}
