<?php
/**
 * @file
 * bassets_client_entity_view_mode.features.inc
 */

/**
 * Implements hook_ctools_plugin_api().
 */
function bassets_client_entity_view_mode_ctools_plugin_api($module = NULL, $api = NULL) {
  if ($module == "file_entity" && $api == "file_default_displays") {
    return array("version" => "1");
  }
  if ($module == "strongarm" && $api == "strongarm") {
    return array("version" => "1");
  }
}

/**
 * Implements hook_image_default_styles().
 */
function bassets_client_entity_view_mode_image_default_styles() {
  $styles = array();

  // Exported image style: large_copyright.
  $styles['large_copyright'] = array(
    'name' => 'large_copyright',
    'label' => 'Large with copyright (480x480)',
    'effects' => array(
      21 => array(
        'label' => 'Scale',
        'help' => 'Scaling will maintain the aspect-ratio of the original image. If only a single dimension is specified, the other dimension will be calculated.',
        'effect callback' => 'image_scale_effect',
        'dimensions callback' => 'image_scale_dimensions',
        'form callback' => 'image_scale_form',
        'summary theme' => 'image_scale_summary',
        'module' => 'image',
        'name' => 'image_scale',
        'data' => array(
          'width' => 480,
          'height' => 480,
          'upscale' => 0,
        ),
        'weight' => -10,
      ),
      22 => array(
        'label' => 'Define canvas',
        'help' => 'Define the size of the working canvas and background color, this controls the dimensions of the output image.',
        'effect callback' => 'canvasactions_definecanvas_effect',
        'dimensions callback' => 'canvasactions_definecanvas_dimensions',
        'form callback' => 'canvasactions_definecanvas_form',
        'summary theme' => 'canvasactions_definecanvas_summary',
        'module' => 'imagecache_canvasactions',
        'name' => 'canvasactions_definecanvas',
        'data' => array(
          'RGB' => array(
            'HEX' => '#fff',
          ),
          'under' => 1,
          'exact' => array(
            'width' => '',
            'height' => '',
            'xpos' => 'center',
            'ypos' => 'center',
          ),
          'relative' => array(
            'leftdiff' => '',
            'rightdiff' => '',
            'topdiff' => '',
            'bottomdiff' => 40,
          ),
        ),
        'weight' => -9,
      ),
      18 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 10,
          'xpos' => 'left+10',
          'ypos' => 'bottom-24',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_caption]',
          'php' => '',
        ),
        'weight' => -8,
      ),
      19 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 10,
          'xpos' => 'left+10',
          'ypos' => 'bottom-12',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_license]',
          'php' => '',
        ),
        'weight' => -7,
      ),
      20 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 10,
          'xpos' => 'left+10',
          'ypos' => 'bottom',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field-asset-license-url:url]',
          'php' => '',
        ),
        'weight' => -6,
      ),
    ),
  );

  // Exported image style: medium_copyright.
  $styles['medium_copyright'] = array(
    'name' => 'medium_copyright',
    'label' => 'Medium with copyright (220x220)',
    'effects' => array(
      26 => array(
        'label' => 'Scale',
        'help' => 'Scaling will maintain the aspect-ratio of the original image. If only a single dimension is specified, the other dimension will be calculated.',
        'effect callback' => 'image_scale_effect',
        'dimensions callback' => 'image_scale_dimensions',
        'form callback' => 'image_scale_form',
        'summary theme' => 'image_scale_summary',
        'module' => 'image',
        'name' => 'image_scale',
        'data' => array(
          'width' => 220,
          'height' => 220,
          'upscale' => 1,
        ),
        'weight' => -10,
      ),
      27 => array(
        'label' => 'Define canvas',
        'help' => 'Define the size of the working canvas and background color, this controls the dimensions of the output image.',
        'effect callback' => 'canvasactions_definecanvas_effect',
        'dimensions callback' => 'canvasactions_definecanvas_dimensions',
        'form callback' => 'canvasactions_definecanvas_form',
        'summary theme' => 'canvasactions_definecanvas_summary',
        'module' => 'imagecache_canvasactions',
        'name' => 'canvasactions_definecanvas',
        'data' => array(
          'RGB' => array(
            'HEX' => '#fff',
          ),
          'under' => 1,
          'exact' => array(
            'width' => '',
            'height' => '',
            'xpos' => 'center',
            'ypos' => 'center',
          ),
          'relative' => array(
            'leftdiff' => '',
            'rightdiff' => '',
            'topdiff' => '',
            'bottomdiff' => 40,
          ),
        ),
        'weight' => -9,
      ),
      23 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 6,
          'xpos' => 'left+10',
          'ypos' => 'bottom-24',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_caption]',
          'php' => '',
        ),
        'weight' => -8,
      ),
      24 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 6,
          'xpos' => 'left+10',
          'ypos' => 'bottom-12',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_license]',
          'php' => '',
        ),
        'weight' => -7,
      ),
      25 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 6,
          'xpos' => 'left+10',
          'ypos' => 'bottom',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field-asset-license-url:url]',
          'php' => '',
        ),
        'weight' => -6,
      ),
    ),
  );

  // Exported image style: thumbnail_copyright.
  $styles['thumbnail_copyright'] = array(
    'name' => 'thumbnail_copyright',
    'label' => 'Thumbnail with copyright (100x100)',
    'effects' => array(
      31 => array(
        'label' => 'Scale',
        'help' => 'Scaling will maintain the aspect-ratio of the original image. If only a single dimension is specified, the other dimension will be calculated.',
        'effect callback' => 'image_scale_effect',
        'dimensions callback' => 'image_scale_dimensions',
        'form callback' => 'image_scale_form',
        'summary theme' => 'image_scale_summary',
        'module' => 'image',
        'name' => 'image_scale',
        'data' => array(
          'width' => 100,
          'height' => 100,
          'upscale' => 1,
        ),
        'weight' => -10,
      ),
      32 => array(
        'label' => 'Define canvas',
        'help' => 'Define the size of the working canvas and background color, this controls the dimensions of the output image.',
        'effect callback' => 'canvasactions_definecanvas_effect',
        'dimensions callback' => 'canvasactions_definecanvas_dimensions',
        'form callback' => 'canvasactions_definecanvas_form',
        'summary theme' => 'canvasactions_definecanvas_summary',
        'module' => 'imagecache_canvasactions',
        'name' => 'canvasactions_definecanvas',
        'data' => array(
          'RGB' => array(
            'HEX' => '#fff',
          ),
          'under' => 1,
          'exact' => array(
            'width' => '',
            'height' => '',
            'xpos' => 'center',
            'ypos' => 'center',
          ),
          'relative' => array(
            'leftdiff' => '',
            'rightdiff' => '',
            'topdiff' => '',
            'bottomdiff' => 40,
          ),
        ),
        'weight' => -9,
      ),
      28 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 4,
          'xpos' => 'left+10',
          'ypos' => 'bottom-24',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_caption]',
          'php' => '',
        ),
        'weight' => -8,
      ),
      29 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 4,
          'xpos' => 'left+10',
          'ypos' => 'bottom-12',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field_asset_license]',
          'php' => '',
        ),
        'weight' => -7,
      ),
      30 => array(
        'label' => 'Text',
        'help' => 'Add static or dynamic (coded) text to an image.',
        'dimensions passthrough' => TRUE,
        'form callback' => 'image_effects_text_form',
        'effect callback' => 'image_effects_text_effect',
        'summary theme' => 'image_effects_text_summary',
        'module' => 'image_effects_text',
        'name' => 'image_effects_text',
        'data' => array(
          'size' => 4,
          'xpos' => 'left+10',
          'ypos' => 'bottom',
          'halign' => 'left',
          'valign' => 'bottom',
          'RGB' => array(
            'HEX' => '#000000',
          ),
          'alpha' => 100,
          'angle' => 0,
          'fontfile' => 'module://imagecache_actions/image_effects_text/Komika_display.ttf',
          'text_source' => 'text',
          'text' => '[file:field-asset-license-url:url]',
          'php' => '',
        ),
        'weight' => -6,
      ),
    ),
  );

  return $styles;
}
