<?php

define('BASSETS_PROFILE_NAME', 'bassets_client_profile');

/**
 * Implements hook_update_projects_alter().
 */
function bassets_client_profile_update_projects_alter(&$projects) {
  // Enable update status for the profile.
  $modules = system_rebuild_module_data();
  // The module object is shared in the request, so we need to clone it here.
  $module = clone $modules[BASSETS_PROFILE_NAME];
  $module->info['hidden'] = FALSE;
  _update_process_info_list($projects, array(BASSETS_PROFILE_NAME => $module), 'module', TRUE);
}

/**
 * Implements hook_update_status_alter().
 */
function bassets_client_profile_update_status_alter(&$projects) {
  $not_alter = variable_get('bassets_no_hook_update_status_alter', FALSE);
  if ($not_alter) {
    return;
  }
  $bad_statuses = array(
    UPDATE_NOT_SECURE,
    UPDATE_REVOKED,
    UPDATE_NOT_SUPPORTED,
  );

  $make_filepath = drupal_get_path('module', BASSETS_PROFILE_NAME) . '/drupal-org.make';
  if (!file_exists($make_filepath)) {
    return;
  }
  $make_info = drupal_parse_info_file($make_filepath);
  foreach ($projects as $project_name => $project_info) {
    // Never unset the drupal project to avoid hitting an error with
    // _update_requirement_check(). See http://drupal.org/node/1875386.
    if ($project_name == 'drupal') {
      continue;
    }
    elseif (isset($make_info['projects'][$project_name])) {

      // Hide bad releases (insecure, revoked, unsupported) if they are younger
      // than two days (giving Bassets time to prepare an update).
      if (isset($project_info['status']) && in_array($project_info['status'], $bad_statuses) && isset($project_info['releases']) && isset($project_info['recommended'])) {
        $two_days_ago = strtotime('2 days ago');
        if ($project_info['releases'][$project_info['recommended']]['date'] < $two_days_ago) {
          unset($projects[$project_name]);
        }
      }
      $version = !empty($make_info['projects'][$project_name]['version']) ? $make_info['projects'][$project_name]['version'] : '';
      $install_type = !empty($project_info['install_type']) ? $project_info['install_type'] : '';
      if (strpos($version, 'dev') !== FALSE || $install_type == 'dev' || (DRUPAL_CORE_COMPATIBILITY . '-' . $version == $project_info['info']['version'])) {
        unset($projects[$project_name]);
      }
      // Has it patches applied?
      elseif (!empty($make_info['projects'][$project_name]['patch']) && count($make_info['projects'][$project_name]['patch'])) {
        unset($projects[$project_name]);
      }
    }
    // Bassets features.
    elseif (substr($project_name, 0, 7) == 'bassets' && $project_info['status'] == UPDATE_UNKNOWN) {
      unset($projects[$project_name]);
    }
  }
}

/**
 * Implements hook_form_FORM_ID_alter().
 *
 * Disable the update for the profile.
 */
function bassets_client_profile_form_update_manager_update_form_alter(&$form, &$form_state, $form_id) {
  if (isset($form['projects']['#options']) && isset($form['projects']['#options'][BASSETS_PROFILE_NAME])) {
    if (count($form['projects']['#options']) > 1) {
      unset($form['projects']['#options'][BASSETS_PROFILE_NAME]);
    }
    else {
      unset($form['projects']);
      // Hide Download button if there's no other (disabled) projects to update.
      if (!isset($form['disabled_projects'])) {
        $form['actions']['#access'] = FALSE;
      }
      $form['message']['#markup'] = t('All of your projects are up to date.');
    }
  }
}
