(function (Drupal, drupalSettings) {
  Drupal.behaviors.bat_fullcalendar = {
    attach: function (context, drupalSettings) {
      once('div', 'html', context).forEach(function (context) {
        window.onload = function(){

        function handyDates() {
          var dates = [];
          var today = new Date();
          var start = new Date();
          var end = new Date();
          start.setDate(today.getDate() - Math.abs(drupalSettings.batCalendar[0].bat_timerange_start));
          end.setDate(today.getDate() + drupalSettings.batCalendar[0].bat_timerange_end);
          dates['today'] = today.toISOString().split(".")[0];
          dates['start'] = start.toISOString().split(".")[0];
          dates['end'] = end.toISOString().split(".")[0];
          return dates;
        }

        function produceCall() {
          var dates = handyDates();
          var call =  '/bat_api/calendar-events?_format=json&unit_types=' + drupalSettings.batCalendar[0].unitType + '&unit_ids=' + drupalSettings.batCalendar[0].unitIds + '&event_types=' + drupalSettings.batCalendar[0].eventType + '&background=' + drupalSettings.batCalendar[0].background + '&start=' + dates['start'] + '&end=' + dates['end'];
          return call;
        }

        async function getAndRender() {
          var call = produceCall ();
          const responseBody = (
            await fetch(call)
          ).json();
            const obj = (await responseBody);
            console.log (obj);
            let settings = [
              ['events', obj]
              // ['events', some_events()]
            ];
            build_the_calendar(settings);
        }

        function build_the_calendar(settings) {
          var dates = handyDates();
          const calendarEl = document.getElementById('calendar')
          // https://fullcalendar.io/docs/event-object
          var calendarOptions = {
              dayMaxEvents: true, //allow "more" link when too many events
              editable: true,
              events: settings[0][1],
              initialView: drupalSettings.batCalendar[0].initialView,
              height: drupalSettings.batCalendar[0].calendarHeight,
              nowIndicator: true,
              headerToolbar: {
                  left: 'prev,next today',
                  center: 'title',
                  right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
              },
              navLinks: true, // can click day/week names to navigate views
              selectable: true,
              selectMirror: true,
              initialDate: dates.today,
          };
          const calendar = new FullCalendar.Calendar(calendarEl, calendarOptions)
          calendar.render()
        }
        getAndRender();

        function some_events()  {
          var events_from_code = [
            {
              title: 'All Day Event',
              start: '2025-02-01',
            },
            {
              title: 'Long Event',
              start: '2025-02-07',
              end: '2025-02-10'
            },
            {
              groupId: 999,
              title: 'Repeating Event',
              start: '2025-02-09T16:00:00'
            },
            {
              groupId: 999,
              title: 'Repeating Event',
              start: '2025-02-16T16:00:00'
            },
            {
              title: 'Conference',
              start: '2025-02-11',
              end: '2025-02-13'
            },
            {
              title: 'Meeting',
              start: '2025-02-12T10:30:00',
              end: '2025-02-12T12:30:00'
            },
            {
              title: 'Lunch',
              start: '2025-02-12T12:00:00'
            },
            {
              title: 'Meeting',
              start: '2025-02-12T14:30:00'
            },
            {
              title: 'Happy Hour',
              start: '2025-02-12T17:30:00'
            },
            {
              title: 'Dinner',
              start: '2025-02-12T20:00:00'
            },
            {
              title: 'Birthday Party',
              start: '2025-02-13T07:00:00'
            },
            {
              title: 'Click for Google',
              url: 'http://google.com/',
              start: '2025-02-28'
            }
          ];
          return events_from_code
        }
      };
    });
    }
  }
}
(Drupal, drupalSettings));
