(function (Drupal, drupalSettings) {
  Drupal.behaviors.bat_fullcalendar = {
    attach: function (context, drupalSettings) {
      once('div', 'html', context).forEach(function (context) {
        window.onload = function(){
          function handyDates() {
            var dates = [];
            var today = new Date();
            var start = new Date();
            var end = new Date();
            start.setDate(today.getDate() - Math.abs(drupalSettings.batCalendar[0].bat_timerange_start));
            end.setDate(today.getDate() + drupalSettings.batCalendar[0].bat_timerange_end);
            dates['today'] = today.toISOString().split(".")[0];
            dates['start'] = start.toISOString().split(".")[0];
            dates['end'] = end.toISOString().split(".")[0];
            return dates;
          }

          function produceCall() {
            var dates = handyDates();
            var call =  '/bat_api/calendar-events?_format=json&unit_types=' + drupalSettings.batCalendar[0].unitType + '&unit_ids=' + drupalSettings.batCalendar[0].unitIds + '&event_types=' + drupalSettings.batCalendar[0].eventType + '&background=' + drupalSettings.batCalendar[0].background + '&start=' + dates['start'] + '&end=' + dates['end'];
            return call;
          }

          async function getAndRender() {
            var call = produceCall ();
            const responseBody = (
              await fetch(call)
            ).json();
              const obj = (await responseBody);

              let lastSegment = location.href.replace(/.*\/(\w+)\/?$/, '$1');

              for (let i = 0; i < obj.length; i++) {

                // should be editable basing user permissions
                obj[i]['editable'] = drupalSettings.batCalendar[0].editable;

                // only /availability has links
                // @todo: we should do this via hook_bat_api_events_index_calendar_alter
                if (lastSegment !='availability')  {
                  obj[i]['url'] = '';
                }

              }

              let settings = [
                ['events', obj]
              ];
              build_the_calendar(settings);
          }

          function build_the_calendar(settings) {
            var dates = handyDates();
            const calendarEl = document.getElementById('calendar')
            // https://fullcalendar.io/docs/event-object
            var calendarOptions = {

                eventDidMount: function(info) {},

                // Buggy
                // schedulerLicenseKey: drupalSettings.batCalendar[0].schedulerLicenseKey,
                allDaySlot: drupalSettings.batCalendar[0].allDaySlot,
                customButtons: drupalSettings.batCalendar[0].customButtons,
                dayMaxEvents: true, //allow "more" link when too many events
                defaultTimedEventDuration: drupalSettings.batCalendar[0].defaultTimedEventDuration,
                displayEventTime: false,
                editable: drupalSettings.batCalendar[0].editable,
                eventDurationEditable: drupalSettings.batCalendar[0].eventDurationEditable,
                eventOrder: drupalSettings.batCalendar[0].eventOrder,
                eventStartEditable: drupalSettings.batCalendar[0].eventStartEditable,
                events: settings[0][1],
                firstDay: drupalSettings.batCalendar[0].firstDay,
                height: drupalSettings.batCalendar[0].calendarHeight,
                initialDate: dates.today,
                initialView: drupalSettings.batCalendar[0].initialView,
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
                },
                height: drupalSettings.batCalendar[0].calendarHeight ? drupalSettings.batCalendar[0].calendarHeight : 300,
                locale: drupalSettings.batCalendar[0].locale,
                navLinks: true, // can click day/week names to navigate views
                nowIndicator: true,
                selectable: drupalSettings.batCalendar[0].selectable,
                selectMirror: true,
                slotLabelFormat: drupalSettings.batCalendar[0].slotLabelFormat,
                themeSystem: drupalSettings.batCalendar[0].themeSystem,
                titleFormat: drupalSettings.batCalendar[0].titleFormat,
            };

            const calendar = new FullCalendar.Calendar(calendarEl, calendarOptions);
            calendar.render();
          }
          getAndRender();
      };
    });
    }
  }
}
(Drupal, drupalSettings));
