<?php

namespace Drupal\bat_event\Util;

use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * Define a maintenance class.
 *
 * Defines the Utility EventMaintenance class.
 * Cloned from https://www.drupal.org/project/bee_hotel.
 */
class EventMaintenance {

  /**
   * Remove old events from database.
   * Deprecated from 07oct23
   */
  public function deleteOldBatEvents($options) {

    if (!isset($options['daysago'])) {
      // @todo set this via UI
      $options['daysago'] = 60;
    }

    if (!isset($options['howmany'])) {
      // @todo set this via UI
      $options['howmany'] = 600;
    }

    $date = new DrupalDateTime($options['daysago'] . ' days ago');
    $date->setTimezone(new \DateTimezone(DateTimeItemInterface::STORAGE_TIMEZONE));
    $formatted = $date->format(DateTimeItemInterface::DATETIME_STORAGE_FORMAT);

    $query = \Drupal::entityQuery('bat_event');
    $query->accessCheck(TRUE);
    $count_pre = $query->count()->execute();
    $ids = \Drupal::entityQuery('bat_event')
      ->accessCheck(TRUE)
      ->condition('event_dates.value', $formatted, '<')
      ->range(0, $options['howmany'])
      ->execute();

    bat_event_delete_multiple($ids);

    $query = \Drupal::entityQuery('bat_event');
    $query->accessCheck(TRUE);
    $count_post = $query->count()->execute();

    $tmp = [
      "%c" => $options['howmany'],
      "%older" => $options['daysago'],
      "%remain" => $count_post,
      "%count_pre" => $count_pre,
    ];

    $message = t("counter_pre : [ %counter_pre ].N. %c bat_event(s)  older than %older days deleted. %remain bat_event(s) still in DB", $tmp);

    \Drupal::logger('bat_event')->notice($message);

  }

  /**
   * {@inheritdoc}
   */
  public function deleteExpiredEvents() {

    $data = [];
    $data['expired'] = \Drupal::config('bat.settings')->get('bat_event_is_expired_after_days');
    $data['enabled'] = \Drupal::config('bat.settings')->get('bat_events_expired_events_is_enabled');


    if (isset($data['enabled']) && $data['enabled'] == 1) {
      $date = new DrupalDateTime($data['expired'] . ' days ago');
      $date->setTimezone(new \DateTimezone(DateTimeItemInterface::STORAGE_TIMEZONE));
      $data['formatted'] = $date->format(DateTimeItemInterface::DATETIME_STORAGE_FORMAT);

      $data['query']['conditions'][] = [
        'field' => "event_dates",
        'value' => $data['formatted'],
        'operator' => "<=",
      ];

      $data['query']['range'] = [
        'from' => 0,
        'to' => 30,
      ];

      $options = ['query'  => $data['query']];
      $data['events'] = bat_event_ids($options);

      if (isset($data['events'])) {

        $message = t("Deleting %count expired BAT events", ['%count' => count($data['events'])]);
        \Drupal::logger('bat_event')->notice($message);

        $storage = \Drupal::entityTypeManager()->getStorage('bat_event');
        $storage->delete($data['events']);
      }
    }
  }








}
