<?php

namespace Drupal\bat_event_ui\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;

/**
 * Description.
 */
class BatEventUiDeleteExpiredForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bat_event_ui_delete_expired_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $unit_type = 'all', $event_type = 'all') {

    $data = [];

    $data['expired'] = \Drupal::config('bat.settings')->get('bat_event_is_expired_after_days');
    $data['enabled'] = \Drupal::config('bat.settings')->get('bat_events_expired_events_is_enabled');

    $data['to_be_deleted'] = 33;

    $form['bulk_delete_expired'] = [
      '#type' => 'fieldset',
      '#title' => t('Delete expired events'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#suffix' => $this->t("As per current settings, %number event are to be deleted", ["%number" => $data['to_be_deleted']]),
    ];

    $form['bulk_delete_expired']['days'] = [
      '#type' => 'select',
      '#title' => $this->t('BAT Event expire after'),
      '#options' => [
        180 => $this->t('6 months'),
        360 => $this->t('1 year'),
        720 => $this->t('2 years'),
        1080 => $this->t('3 years'),
      ],
      '#multiple' => FALSE,
      '#default_value' => $data['expired'],
      '#description' => [
        [
          '#markup' => $this->t('Select when a BAT event is meant to be expired. Note:'),
        ],
        [
          '#theme' => 'item_list',
          '#items' => [
            $this->t('Expired events will be deleted from DB'),
            $this->t('Related entities may be affected by this action'),
          ],
        ],
        [
          '#markup' => $this->t('
          Deleting expired events is designed to reduce the DB size, removing useless data. <strong>Be sure selected events are no more needed</strong> inside your Drupal.') . '<br />',
        ],
      ],
    ];

    $form['bulk_delete_expired']['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('<strong>Yes</strong>, delete expired events.'),
      '#description' => $this->t('With this checkbox, expired events <strong>will be removed</strong> from database.'),
      '#default_value' => $data['enabled'],
    ];

    $form['bulk_delete_expired']['submit'] = [
      '#type' => 'submit',
      '#value' => t('Save'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {}

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $config = \Drupal::service('config.factory')->getEditable('bat.settings');
    $config->set('bat_event_is_expired_after_days', $values['days'])->save();
    $config->set('bat_events_expired_events_is_enabled', $values['enabled'])->save();
  }

}
