<?php

namespace Drupal\batch\Batch;

use Drupal\Core\Batch\BatchBuilder as CoreBatchBuilder;

/**
 * Extends core batch builder to handle operation classes.
 */
class BatchBuilder extends CoreBatchBuilder {

  /**
   * Adds a batch operation.
   *
   * @param BatchOperationInterface $operation
   *   The operation to add.
   *
   * @return $this
   */
  public function addBatchOperation(BatchOperationInterface $operation): self {
    return $this->addOperation([$operation, 'process']);
  }

  /**
   * Set the finished operation.
   *
   * @param \Drupal\batch\Batch\BatchFinishInterface $finished
   *   The finished operation.
   *
   * @return $this
   */
  public function setFinishOperation(BatchFinishInterface $finished): self {
    return $this->setFinishCallback([$finished, 'finished']);
  }

}
