<?php

namespace Drupal\batch\Batch\Operation;

/**
 * Base class for enumerated operations.
 */
abstract class EnumeratedOperationBase extends OperationBase {

  /**
   * Items to process in the batch.
   *
   * @param array $items
   */
  public function __construct(protected array $items = []) {
    // No op.
  }

  /**
   * Set the items to process in the batch.
   *
   * @param array $items
   *   The items to process in the batch.
   *
   * @return $this
   */
  public function setItems(array $items): self {
    $this->items = $items;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function process(array &$context): void {
    // First time through, grab items and total count.
    if (empty($context['sandbox'])) {
      $context['sandbox']['items'] = $this->items;
      $context['sandbox']['total'] = count($context['sandbox']['items']);
    }

    $processed = 0;
    while ($processed++ < $this->itemsPerProcess) {
      if ($item = array_shift($context['sandbox']['items'])) {
        $this->processItem($item, $context);
      }

      // If none left, we're done.
      if (empty($context['sandbox']['items'])) {
        return;
      }
    }

    if ($this->reclaimMemory()) {
      $context['message'] .= ' - Reclaiming memory';
    }

    $count = count($context['sandbox']['items']);
    $context['finished'] = 1 - ($count / $context['sandbox']['total']);
    $context['finished'] = min($context['finished'], .9999);
  }

}
