<?php

namespace Drupal\batch\Batch;

use Drupal\batch\Batch\Finish\FinishInterface;
use Drupal\batch\Batch\Operation\OperationInterface;
use Drupal\Core\Batch\BatchBuilder as CoreBatchBuilder;

/**
 * Extends core batch builder to handle operation classes.
 */
class BatchBuilder extends CoreBatchBuilder {

  /**
   * Adds a batch operation.
   *
   * @param \Drupal\batch\Batch\Operation\OperationInterface $operation
   *   The operation to add.
   *
   * @return $this
   */
  public function addBatchOperation(OperationInterface $operation): self {
    return $this->addOperation([$operation, 'process']);
  }

  /**
   * Set the finished operation.
   *
   * @param \Drupal\batch\Batch\Finish\FinishInterface $finish
   *   The batch finish operation.
   *
   * @return $this
   */
  public function setFinishOperation(FinishInterface $finish): self {
    return $this->setFinishCallback([$finish, 'finished']);
  }

}
