<?php

namespace Drupal\batch\Batch\Finish;

use Drupal\Core\Messenger\MessengerTrait;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Default implementation for a batch finish operation.
 */
class FinishDefault implements FinishInterface {

  use MessengerTrait;

  /**
   * URL for redirection upon batch completion.
   *
   * @var \Drupal\Core\Url|null
   */
  protected Url|null $redirectUrl = NULL;

  /**
   * {@inheritdoc}
   */
  public function setRedirectUrl(Url $url): self {
    $this->redirectUrl = $url;
    return $this;
  }

  /**
   * Batch finished callback.
   *
   * @param bool $success
   *   A boolean indicating whether the batch has completed successfully.
   * @param mixed $results
   *   The value set in $context['results'] by callback_batch_operation().
   * @param array $operations
   *   If $success is FALSE, contains the operations that remained unprocessed.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse|null
   *   A redirect, or NULL if no redirect.
   */
  public function finished(bool $success, mixed $results, array $operations): ?RedirectResponse {
    if (!empty($this->redirectUrl)) {
      return new RedirectResponse($this->redirectUrl->toString());
    }
    return NULL;
  }

}
