<?php

namespace Drupal\batch\Batch\Finish;

use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Operation to run upon batch completion.
 */
interface FinishInterface {

  /**
   * Batch finished callback.
   *
   * @param bool $success
   *   A boolean indicating whether the batch has completed successfully.
   * @param mixed $results
   *   The value set in $context['results'] by callback_batch_operation().
   * @param array $operations
   *   If $success is FALSE, contains the operations that remained unprocessed.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse|null
   *   A redirect, or NULL if no redirect.
   */
  public function finished(bool $success, mixed $results, array $operations): ?RedirectResponse;

  /**
   * Set a URL for redirection upon completing the batch.
   *
   * @param \Drupal\Core\Url $url
   *   The URL for redirection.
   *
   * @return $this
   */
  public function setRedirectUrl(Url $url): self;

}
