<?php

namespace Drupal\batch\Batch\Operation;

/**
 * Batch operation interface.
 */
interface OperationInterface {

  /**
   * Set the number of items to process during each processing run.
   *
   * @param int $itemsPerProcess
   *   The number of items to process during each processing run.
   *
   * @return $this
   */
  public function setItemsPerProcess(int $itemsPerProcess): self;

  /**
   * Process items in the batch.
   *
   * @param array $context
   *   The batch context.
   */
  public function process(array &$context): void;

}
