/**
 * @file Javascript for batch jobs.
 */

(function ($) {

  Drupal.behaviors.batch_jobs = {
    attach: function (context, settings) {
      var batch = $('div.batch').attr('class');
      if (typeof batch !== 'undefined') {
        batch = batch.split(' ');
        batch = batch[1];
        batch = batch.split('-');
        var bid = batch[1];
        var progress = 0;
        $('#progress').progressbar({
          value: progress
        });
        $('div.batch-percent').html(progress + '%');
        $.get(Drupal.settings.basePath + 'batch_jobs/' + bid + '/callback',
          null, updateProgressBar);
      }

      $('div.batch_jobs').find('button').click(function(event) {
        var batch = $(this).parent().parent().attr('class');
        batch = batch.split(' ');
        batch = batch[0];
        batch = batch.split('-');
        var bid = batch[1];
        if (confirm('Delete job ' + bid + '?') == true) {
          $.get(Drupal.settings.basePath + 'batch_jobs/' + bid + '/delete',
            null, updateJobs);
        }
      });
    }
  };

  var updateProgressBar = function(response) {
    if (response.status) {
      var progress = Math.round(10000.0 * (response.complete /
        response.total)) / 100.0;
      $('#progress').progressbar({
        value: progress
      });
      $('div.batch-complete').html(response.complete + ' of ' + response.total);
      $('div.batch-percent').html(progress + '%');
      if (response.complete == response.total) {
        $.get(Drupal.settings.basePath + 'batch_jobs/' + response.bid +
          '/finished', null, jobFinished);
      }
      else {
        $.get(Drupal.settings.basePath + 'batch_jobs/' + response.bid +
          '/callback', null, updateProgressBar);
      }
    }
  };

  var jobFinished = function(response) {
    $('div.batch-complete').append('<p><a href ="' + Drupal.settings.basePath +
      'admin/reports/batch_jobs">Batch jobs</a></p>');
  };

  var updateJobs = function(response) {
    if (response.status) {
      $('tr.batch-' + response.bid).remove();
    }
  };
})(jQuery);
