<?php

namespace Drupal\batch_plugin\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines batch_plugin annotation object.
 *
 * @Annotation
 */
class BatchPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $title;

  /**
   * The description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * An comma separated list of processors that can run the plugin.
   *
   * If empty, any can be used.
   *
   * The first one in the list will be the default if you process without
   * first specifying a processor.
   *
   * @var string
   */
  public $processors;

  /**
   * The permission required to edit or run the plugin from batch_plugin_entity.
   *
   * Defaults to administer batch_plugin_entity.
   *
   * @var string
   */
  public $permission;

}
