<?php

namespace Drupal\batch_plugin\Plugin\Processor;

use Drupal\batch_plugin\BatchPluginInterface;
use Drupal\batch_plugin\ProcessorPluginBase;

/**
 * Plugin implementation of the processor.
 *
 * @Processor(
 *   id = "cron_queue",
 *   label = @Translation("CRON Queue"),
 *   description = @Translation("CRON Queue.")
 * )
 */
class CronQueue extends ProcessorPluginBase {

  /**
   * {@inheritDoc}
   */
  public function addOperations(BatchPluginInterface $batch_plugin, array|\DrushBatchContext $context = []) {
    // @todo create a new queue worker dynamically, matching the plugin ID.
    parent::addOperations($batch_plugin, $context);
    $queue = \Drupal::queue('batch_plugin_queue_worker');
    foreach ($this->operations as $item) {
      $queue->createItem($item);
    }
  }

}
