<?php

namespace Drupal\batch_plugin\Plugin\QueueWorker;

use Drupal\batch_plugin\PluginCreationTrait;
use Drupal\batch_plugin\ProcessorPluginManagerInterface;
use Drupal\Core\Queue\QueueWorkerBase;

/**
 * Process files from jobs.
 *
 * @QueueWorker(
 *   id = "batch_plugin_queue_worker",
 *   title = @Translation("Batch plugin queue worker."),
 *   cron = {"time" = 60}
 * )
 */
class BatchPluginQueueWorker extends QueueWorkerBase {

  use PluginCreationTrait;

  /**
   * The processor plugin mananger service.
   *
   * @var \Drupal\batch_plugin\ProcessorPluginManagerInterface
   */
  protected ProcessorPluginManagerInterface $processorPluginManager;

  /**
   * {@inheritDoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->processorPluginManager = \Drupal::service('plugin.manager.batch_plugin_processor');
  }

  /**
   * {@inheritDoc}
   */
  public function processItem($data): void {
    $batch_plugin = static::createBatchPlugin($data['batch_plugin_id'], $data['batch_plugin_configuration']);
    $function = $data['operation_callback'];
    $payload = $data['operation_payload'];
    $context = [];
    $batch_plugin->$function($payload, $context);
  }

}
