<?php

namespace Drupal\batch_plugin;

/**
 * Plugin creation trait.
 */
trait PluginCreationTrait {

  /**
   * Create a batch plugin.
   *
   * @param string $plugin_id
   *   The plugin ID.
   * @param array $configuration
   *   The configuration.
   *
   * @return \Drupal\batch_plugin\BatchPluginInterface
   *   The plugin.
   */
  protected static function createBatchPlugin($plugin_id, array $configuration): BatchPluginInterface {
    return static::createPlugin($plugin_id, $configuration, 'plugin.manager.batch_plugin');
  }

  /**
   * Create a batch plugin.
   *
   * @param string $plugin_id
   *   The plugin ID.
   *
   * @return \Drupal\batch_plugin\ProcessorInterface
   *   The plugin.
   */
  protected static function createProcessorPlugin($plugin_id): ProcessorInterface {
    return static::createPlugin($plugin_id, [], 'plugin.manager.batch_plugin_processor');
  }

  /**
   * Create a plugin.
   *
   * @param string $plugin_id
   *   The plugin ID.
   * @param array $configuration
   *   The configuration.
   * @param string $service_id
   *   The plugin manager service ID.
   *
   * @return \Drupal\batch_plugin\BatchPluginInterface|\Drupal\batch_plugin\ProcessorInterface
   *   The plugin.
   */
  protected static function createPlugin($plugin_id, array $configuration, $service_id): BatchPluginInterface|ProcessorInterface {
    /** @var \Drupal\plugin\Plugin\DataType\PluginInspectionInterface $manager */
    $manager = \Drupal::service($service_id);
    /** @var \Drupal\batch_plugin\BatchPluginInterface $plugin */
    $plugin = $manager->createInstance($plugin_id, $configuration);
    return $plugin;
  }

}
