<?php

namespace Drupal\batch_plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for processor plugins.
 */
interface ProcessorInterface extends PluginInspectionInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label();

  /**
   * Add operation to the processor.
   *
   * @param \Drupal\batch_plugin\BatchPluginInterface $batch_plugin
   *   The batch plugin.
   * @param array|\DrushBatchContext $context
   *   Any context needed for the batch plugin, e.g. batch API's context.
   *
   * @return mixed
   *   The return;
   */
  public function addOperations(BatchPluginInterface $batch_plugin, array|\DrushBatchContext $context = []);

}
