<?php

namespace Drupal\batch_plugin;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for processor plugins.
 */
abstract class ProcessorPluginBase extends PluginBase implements ProcessorInterface {

  use PluginCreationTrait;

  /**
   * The batch plugin.
   *
   * IMPORTANT - if using batch API this will be created statically,
   *  therefore this may not be available when processing.
   *
   * @var \Drupal\batch_plugin\BatchPluginInterface
   */
  protected BatchPluginInterface $batchPlugin;

  /**
   * The operations, which comes from the batch plugin.
   *
   * IMPORTANT - if using batch API this will be created statically,
   *   therefore this may not be available when processing.
   *
   * @var array
   */
  protected array $operations;

  /**
   * {@inheritdoc}
   */
  public function label() {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function addOperations(BatchPluginInterface $batch_plugin, array|\DrushBatchContext $context = []) {
    $this->batchPlugin = $batch_plugin;
    $operations = $batch_plugin->getOperations();
    foreach ($operations as $operation) {
      $this->operations[] = [
        'batch_plugin_id' => $batch_plugin->getPluginId(),
        'batch_plugin_configuration' => $batch_plugin->getConfiguration(),
        'operation_callback' => $batch_plugin->getOperationCallback(),
        'operation_payload' => $operation,
        'context' => $context,
        'operations_count' => count($operations),
      ];
    }
  }

}
