<?php

namespace Drupal\batch_plugin;

use Drupal\Component\Plugin\PluginManagerInterface;

/**
 * Process Batch Interface.
 */
interface ProcessorPluginManagerInterface extends PluginManagerInterface {

  /**
   * Process a plugin.
   *
   * @param \Drupal\batch_plugin\BatchPluginInterface $batch_plugin
   *   The batch plugin.
   * @param string $processor_plugin_id
   *   Optional parameter to override the processor plugin ID.
   *
   * @return mixed
   *   The results.
   */
  public function processBatchPlugin(BatchPluginInterface $batch_plugin, $processor_plugin_id = ''): mixed;

  /**
   * Add operations to a batch.
   *
   * @param \Drupal\batch_plugin\BatchPluginInterface $batch_plugin
   *   The batch plugin.
   * @param \Drupal\batch_plugin\ProcessorInterface $processor
   *   The processor plugin.
   * @param array|\DrushBatchContext $context
   *   Any context, e.g. from Batch API.
   */
  public function addBatch(BatchPluginInterface $batch_plugin, ProcessorInterface $processor, array|\DrushBatchContext $context = []): void;

  /**
   * Get a list of plugin options, e.g. for Form API select elements.
   *
   * @param \Drupal\batch_plugin\BatchPluginInterface|null $batchPlugin
   *   The batch plugin to check against with processor annotations.
   *
   * @return array
   *   The options.
   */
  public function getProcessorOptions(BatchPluginInterface $batchPlugin = NULL): array;

}
