// At least some Drupal css themes apply "height: auto" to all img
// elements, which then sets the height of bars in .chartimg classes
// to zero, as created in modules/render_htmlchart.inc.php. The
// Xss::filter() function through which all content passes removes
// style attributes from img elements, meaning we can't set the height
// and width via style attributes. This code works around this problem by
// transferring img.height to img.style.height.
Drupal.behaviors.bawstatsBehavior = {
  attach: function (context, settings) {
    once('bawstatsBehavior', 'img.chartimg', context).forEach(function (element) {
      element.style.height = element.getAttribute('height') + 'px';
    });
  }
}
