<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats
 *
 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// global $BAW_MES;

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'config_default.php') !== false) {
    die ('This file can not be used on its own!');
}

$BAW_CONF_DEF = array(
    'Site Settings' => array (
        'path_data' => array (
            'type' => 'string',
            'name' => 'Path to AWStats Data',
            'default' => '/path/to/betterawstats/awstats/data',
            'help' => "Set this value to the directory where AWStats "
                . "saves its database files into."
                . "ATTENTION: If you read those files on windows but have them created on linux "
                . "or the other way round, make sure you transfer them 'BINARY'. Otherwise they "
                . "cannot be read properly. No trailing slash"
        ),
        'path_lib' => array (
            'type' => 'string',
            'name' => 'Path to AWStats Libraries',
            'default' => '/path/to/betterawstats/awstats/lib',
            'help' => "Set this value to the directory where AWStats "
                . "saves its library files into. No trailing slash"

        ),
        'path_lang' => array (
            'type' => 'string',
            'name' => 'Path to AWStats Language files',
            'default' => '/path/to/betterawstats/awstats/lang',
            'help' => "Set this value to the directory where AWStats "
                . "saves its language files into. No trailing slash"

        ),
        'site_url' => array (
            'type' => 'string',
            'name' => 'Script URL',
            'default' => 'http://awstats.local',
            'help' => "The url of BetterAWstats, No trailing slash"

        ),
        'icons_url' => array (
            'type' => 'string',
            'name' => 'AWStats Icons URL',
            'default' => "\$BAW_CONF['site_url'] . '/awstats/icon'",
            'help' => "The url to the awstats icons, should include the whole http://...,"
                . "no trailing slash"
        ),
        'online_config' => array (
            'type' => 'dropdown',
            'name' => 'Web Configuration',
            'default' => 'false',
            'help' => "Enable the online configuator?",
            'values' => array('true'=>'Enable', 'false'=>'Disable')
        ),
    ),
    'Layout Settings' => array (
        'layout_type'=> array (
            'type' => 'dropdown',
            'name' => 'Layout Type',
            'default' => 'style',
            'help' => "Display page in vertical or horizontal layout?",
            'values' => array('style'=>'Vertical', 'compact'=>'Horizontal')
        ),
        'lang_setting' => array (
            'type' => 'dropdown',
            'name' => 'Language',
            'default' => "auto",
            'help' => "Set your language. First available language accepted by browser=auto",
            'values' => array(
                'auto'=>'Automatic',
                'al'=>'Albanian','ba'=>'Bosnian','bg'=>'Bulgarian','ca'=>'Catalan',
                'tw'=>'Chinese (Taiwan)','cn'=>'Chinese (Simpliefied)','cz'=>'Czech',
                'dk'=>'Danish','nl'=>'Dutch','en'=>'English','et'=>'Estonian',
                'eu'=>'Euskara','fi'=>'Finnish','fr'=>'French','gl'=>'Galician',
                'de'=>'German','gr'=>'Greek','he'=>'Hebrew','hu'=>'Hungarian',
                'is'=>'Icelandic','id'=>'Indonesian','it'=>'Italian','jp'=>'Japanese',
                'kr'=>'Korean','lv'=>'Latvian','nn'=>'Norwegian (Nynorsk)',
                'nb'=>'Norwegian (Bokmal)','pl'=>'Polish','pt'=>'Portuguese',
                'br'=>'Portuguese (Brazilian)','ro'=>'Romanian','ru'=>'Russian',
                'sr'=>'Serbian','sk'=>'Slovak','es'=>'Spanish','se'=>'Swedish',
                'tr'=>'Turkish','ua'=>'Ukrainian','wlk'=>'Welsh'
            )
        ),
        'firstdayofweek' => array (
            'type' => 'dropdown',
            'name' => 'First day of the week',
            'default' => 1,
            'help' => "Should Sunday be the first day of the week or monday?",
            'values' => array(1=>'Monday', 2=>'Sunday')
        ),
        'dec_point' => array (
            'type' => 'string',
            'name' => 'Decimal Point',
            'default' => ".",
            'help' => "Decimal Point Character (99.9)"
        ),
        'tho_point' => array (
            'type' => 'string',
            'name' => 'Thousands separator',
            'default' => "'",
            'help' => "Thousand Digit separator (1'000)"
        ),
        'percent_decimals' => array (
            'type' => 'string',
            'name' => 'Percentage decimals',
            'default' => 1,
            'help' => "How many decimals for percentage value? (99.9%)"
        ),
        'xhtml' => array (
            'type' => 'dropdown',
            'name' => 'XHTML/ HTML',
            'default' => ' ',
            'help' => "Do you want output in HTML or XHTML?",
            'values' => array(' '=>'HTML', '/'=>'XHTML')
        ),
        'field_length' => array (
            'type' => 'string',
            'name' => 'Field Length',
            'default' => 65,
            'help' => "What is the max. length of table fields?"
        ),
        'maxlines' => array (
            'type' => 'string',
            'name' => 'Max. Table Lines',
            'default' => 10000,
            'help' => "What is the max. no. of lines a table can have? Set to false to disable"
        ),
        'hideempty'=> array (
            'type' => 'dropdown',
            'name' => 'Hide Empty data',
            'default' => 'false',
            'help' => "Completely hide graps with zero entries? (The menu will always show the entry)",
            'values' => array('true'=>'Hide', 'false'=>'Show')
        ),
    ),
    'Chart Settings'=> array(
        'max_visitors' => array(
            'type' => 'dropdown',
            'name' => 'Max scale for Visitors',
            'default' => "layout_visits",
            'help' => "The maximum of the chosen will define the maximum height of the Visitors",
            'values' => array(
                'layout_visitos'=>'Visitors',
                'layout_visits'=>'Visits',
                'layout_pages'=>'Pages',
                'layout_hits'=>'Hits',
                'layout_bytes'=>'Bytes',
            )
        ),
        'max_visits' => array(
            'type' => 'dropdown',
            'name' => 'Max scale for Visits',
            'default' => "layout_visits",
            'help' => "The maximum of the chosen will define the maximum height of the Visits",
            'values' => array(
                'layout_visits'=>'Visits',
                'layout_pages'=>'Pages',
                'layout_hits'=>'Hits',
                'layout_bytes'=>'Bytes',
            )
        ),
        'max_pages' => array(
            'type' => 'dropdown',
            'name' => 'Max scale for PAges',
            'default' => "layout_pages",
            'help' => "The maximum of the chosen will define the maximum height of the Pages",
            'values' => array(
                'layout_pages'=>'Pages',
                'layout_hits'=>'Hits',
                'layout_bytes'=>'Bytes',
            )
        ),
        'max_hits' => array(
            'type' => 'dropdown',
            'name' => 'Max scale for Hits',
            'default' => "layout_hits",
            'help' => "The maximum of the chosen will define the maximum height of the Hits",
            'values' => array(
                'layout_hits'=>'Hits',
                'layout_bytes'=>'Bytes',
            )
        ),
        'avg_zero' => array(
            'type' => 'dropdown',
            'name' => 'Include Zero-Values in averages',
            'default' => 'false',
            'help' => "Include chart entries that have 0 hits into the average calculation? (After the first set with data, following 0-values will count!)",
            'values' => array('true'=>'Include', 'false'=>'Exclude')
        ),
    ),
        /* 'use_jpgraph' => array (
            'type' => 'dropdown',
            'name' => 'Enable JPgraph?',
            'default' => 'false',
            'help' => "To use JPGraph, you have to download it <a href=\"http://www.aditus.nu/jpgraph/jpdownload.php\">here</a>",
            'values' => array('true'=>'Enable', 'false'=>'Disable')
        ),
        'jpgraph_path' => array (
            'type' => 'string',
            'name' => 'Path to JPGraph',
            'default' => '/path/to/betterawstats/jpgraph/src',
            'help' => "Where is your JPGraph installation? (The folder where jpgraph.php is in. No trailing slash)"
        ),
        'jpgraph_temp' => array (
            'type' => 'string',
            'name' => 'Path to JPGraph temp files',
            'default' => '/path/to/betterawstats/modules/jpgraph_temp',
            'help' => "Where shall awstats put the generated images. This folder has to be accessible from the outside. No trailing slash."
        ),
        'jpgraph_temp_url' => array (
            'type' => 'string',
            'name' => 'URL to JPGraph temp files',
            'default' => 'http://awstats.local/temp',
            'help' => "This is the url to the files generated by jpgraph. the location is identical with jpgraph_temp, but the URL instead of the path. No trailing slash"
        ),*/
    'Advanced Settings' => array (
        'version' => array (
            'type' => 'fixed',
            'name' => 'Version',
            'default' => "1.0 BETA",
            'help' => "Version of this software"
        ),
        'debug' => array (
            'type' => 'dropdown',
            'name' => 'Debug',
            'default' => 'false',
            'help' => "Do you want to show debug-output?",
            'values' => array('true'=>'Yes', 'false'=>'No')
        ),
        'show_time' => array (
            'type' => 'dropdown',
            'name' => 'Time Info',
            'default' => 'false',
            'help' => "Do you want to show detailed time-info for progress?",
            'values' => array('true'=>'Yes', 'false'=>'No')
        ),
        'show_parser_stats' => array (
            'type' => 'dropdown',
            'name' => 'Parser Stats',
            'default' => 'false',
            'help' => "Do you want to show detailed Logfile Parsing stats?",
            'values' => array('true'=>'Yes', 'false'=>'No')
        ),
        'module' => array (
            'type' => 'dropdown',
            'name' => 'Module settings',
            'default' => 'false',
            'help' => "Are you using BetterAWstats as a module for another software? (This is not working yet)",
            'values' => array('false'=>'No') // , 'drupal'=>'Drupal'
        )
    )
);

$BAW_CONF_DIS_DEF = array (
    'overview' => array (
        'help' => 'General Overview of key figures and dates',
        'name' => $BAW_MES[128]
    ),
    'months' => array (
        'help' => 'Monthly data',
        'name' => $BAW_MES[162],
        /* 'sorting' => array(
            0 => $BAW_MES[5],
            1 => $BAW_MES[11],
            2 => $BAW_MES[10],
            3 => $BAW_MES[56],
            4 => $BAW_MES[57],
            5 => $BAW_MES[75]
        )*/
    ),
    'days' => array (
        'help' => 'Daily data',
        'name' => $BAW_MES[138],
        /* 'sorting' => array(
            0 => $BAW_MES[4],
            1 => $BAW_MES[10],
            2 => $BAW_MES[56],
            3 => $BAW_MES[57],
            4 => $BAW_MES[75]
        )*/
    ),
    'weekdays' => array (
        'help' => 'Weekdays',
        'name' => $BAW_MES[91],
        /* 'sorting' => array(
            0 => $BAW_MES[4],
            1 => $BAW_MES[10],
            2 => $BAW_MES[56],
            3 => $BAW_MES[57],
            4 => $BAW_MES[75]
        )*/
    ),
    'hours' => array (
        'help' => 'Hours of the day',
        'name' => $BAW_MES[20],
        'sorting' => array(
            0 => $BAW_MES[20],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57],
            3 => $BAW_MES[75]
        )
    ),
    'domains' => array (
        'help' => 'Domains of visitors',
        'name' => $BAW_MES[25],
        'sorting' => array(
            2 => $BAW_MES[25],
            3 => $BAW_MES[56],
            4 => $BAW_MES[57],
            5 => $BAW_MES[75]
        )
    ),
    'visitors' => array (
        'help' => 'IP addresses of visitors',
        'name' => $BAW_MES[81],
        'sorting' => array(
            0 => $BAW_MES[81],
            // 1 => $BAW_MES[114],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57],
            3 => $BAW_MES[75],
            4 => $BAW_MES[9]
        ),
        'hidebots' => false
    ),
    'logins' => array (
        'help' => 'Logins for username/password protected pages',
        'name' => $BAW_MES[94],
        'sorting' => array(
            0 => $BAW_MES[94],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57],
            3 => $BAW_MES[75],
            4 => $BAW_MES[9]
        )
    ),
    'robots' => array (
        'help' => 'Spiders, Robots of Search engines etc.',
        'name' => $BAW_MES[53],
        'sorting' => array(
            0 => $BAW_MES[53],
            1 => $BAW_MES[57],
            2 => $BAW_MES[57]. " (robots.txt)",
            3 => $BAW_MES[75],
            4 => $BAW_MES[9]
        )
    ),
    'worms' => array (
        'help' => 'Worms searching for security holes',
        'name' => $BAW_MES[163],
        'sorting' => array(
            0 => $BAW_MES[163],
            1 => $BAW_MES[167],
            2 => $BAW_MES[57],
            3 => $BAW_MES[75],
            4 => $BAW_MES[9]
        )
    ),
    'sessions' => array (
        'help' => 'How long have people been on the site?',
        'name' => $BAW_MES[117]
    ),
    'filetype' => array (
        'help' => 'What filetypes are on the site',
        'name' => $BAW_MES[73],
        'sorting' => array(
            0 => $BAW_MES[73],
            1 => $BAW_MES[57],
            2 => $BAW_MES[75],
            3 => $BAW_MES[100],
            4 => $BAW_MES[101],
            5 => $BAW_MES[99]
        )
    ),
    'urls' => array (
        'help' => 'Pages on the site',
        'name' => $BAW_MES[19],
        'sorting' => array(
            0 => $BAW_MES[19],
            1 => $BAW_MES[29],
            2 => $BAW_MES[106],
            3 => $BAW_MES[104],
            4 => $BAW_MES[116]
        )
    ),
    'os' => array (
        'help' => 'Operating system of users',
        'name' => $BAW_MES[59],
        'sorting' => array(
            1 => $BAW_MES[59],
            2 => $BAW_MES[57]
        )
    ),
    'unknownos' => array (
        'help' => 'Unknown Operating system',
        'name' => $BAW_MES[46],
        'sorting' => array(
            1 => 'User Agent',
            2 => $BAW_MES[9]
        )
    ),
    'osversions' => array (
        'help' => 'Operating system of users including versions',
        'name' => "{$BAW_MES[59]} (+{$BAW_MES[58]})",
        'sorting' => array(
            1 => $BAW_MES[59],
            2 => $BAW_MES[57]
        )
    ),
    'browsers' => array (
        'help' => 'Browsers of Users',
        'name' => $BAW_MES[21],
        'sorting' => array(
            1 => $BAW_MES[21],
            2 => $BAW_MES[111],
            3 => $BAW_MES[57]
        ),
        'hasdetail' => 'browserversions'
    ),
    'browserversions' => array (
        'help' => 'Browsers of Users {$BAW_MES[21]} (+{$BAW_MES[58]})',
        'name' => "{$BAW_MES[21]} (+{$BAW_MES[58]})",
        'sorting' => array(
            2 => $BAW_MES[21],
            3 => $BAW_MES[111],
            4 => $BAW_MES[57]
        ),
        'hascompact' => 'browsers'
    ),
    'unknownbrowser' => array (
        'help' => 'Unknown Browsers',
        'name' => $BAW_MES[50],
        'sorting' => array(
            1 => 'User Agent',
            2 => $BAW_MES[9]
        )
    ),
    'screensizes' => array (
        'help' => 'Screensizes of users',
        'name' => $BAW_MES[135],
        'sorting' => array(
            0 => $BAW_MES[135],
            1 => $BAW_MES[57]
        )
    ),
    'se_referers' => array (
        'help' => 'Referrals from search engines',
        'name' => $BAW_MES[126],
        'sorting' => array(
            0 => $BAW_MES[126],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57]
        )
    ),
    'referers' => array (
        'help' => 'Referrals from other sites',
        'name' => $BAW_MES[127],
        'sorting' => array(
            0 => $BAW_MES[127],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57]
        ),
        'hasdetail' => 'referer_domains'
    ),
    'referer_domains' => array (
        'help' => 'Referrals from other sites, grouped by 2-nd level domains',
        'name' => $BAW_MES[127] . " Domains",
        'sorting' => array(
            0 => $BAW_MES[127],
            1 => $BAW_MES[56],
            2 => $BAW_MES[57]
        ),
        'hascompact' => 'referers'
    ),
    'hotlinks' => array (
        'help' => 'Pages linking to images/data on your site',
        'name' => $BAW_MES[127] . " Hotlinks",
        'sorting' => array(
            0 => $BAW_MES[127],
            // 1 => $BAW_MES[56],
            1 => $BAW_MES[57]
        ),
        'hasdetail' => 'hotlink_domains'
    ),
    'hotlink_domains' => array (
        'help' => 'Domains linking to images/data on your site',
        'name' => $BAW_MES[127] . " Hotlinks by Domain",
        'sorting' => array(
            0 => $BAW_MES[127],
            // 1 => $BAW_MES[56],
            1 => $BAW_MES[57]
        ),
        'hascompact' => 'hotlinks'
    ),
    'searchphrases' => array (
        'help' => 'Search phrases',
        'name' => $BAW_MES[120],
        'sorting' => array(
            0 => $BAW_MES[103],
            1 => $BAW_MES[57]
        )
    ),
    'searchwords' => array (
        'help' => 'Search words',
        'name' => $BAW_MES[121],
        'sorting' => array(
            0 => $BAW_MES[13],
            1 => $BAW_MES[57]
        )
    ),
    'misc' => array (
        'help' => 'User system features',
        'name' => $BAW_MES[139]
    ),
    'errors' => array (
        'help' => 'Acesses to pages that returned errors',
        'name' => $BAW_MES[32],
        'sorting' => array(
            0 => $BAW_MES[32],
            2 => $BAW_MES[57],
            3 => $BAW_MES[106]
        )
    ),
    'errors404' => array (
        'help' => $BAW_MES[47],
        'name' => $BAW_MES[49],
        'sorting' => array(
            0 => $BAW_MES[49],
            1 => $BAW_MES[57],
            2 => $BAW_MES[57]
        )
    ),

    // Please make sure to read /docs/install.txt to see all places where you have to
    // edit items to see your extras
    // to add more extras-sections, please copy the following section as often as
    // you need and edit the extras_1 to extras_2 etc. Also change the text to
    // the desired descriptions.

    // copy section start below here
    'extra_1' => array (
        'help' => 'Screen colors of users',
        'name' => "Color depth",
        'sorting' => array(
            0 => 'Color depth in bits',
            1 => $BAW_MES[57]
        )
    ),
    // copy section end above here

   // insert copies here

);
?>