<?php
 // $Id: bawstats.map.inc,v 1.1 2007/11/23 11:47:57 anaru Exp $

/**
 * BAWstats drupal module
 *
 * BAWstats is a drupal module written in php for integration of
 * the BetterAWstats presentation and processing of AWstats data into drupal.
 * Copyright (C) 2007  Andrew Gillies (anaru@equivocation.org)
 *
 * For more information about BetterAWstats see:
 * http://www.tokyoahead.com/main/staticpages/index.php/betterawstats
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or, at
 * your option, any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/**
 * function to render the world map using gd, and display domains
 * this is called using the MENU_CALLBACK with two arguments;
 *   $dataref is which data it is (deptemining the type/color of the marker)
 *   $clist a list of domains and numbers for each domain
 * e.g. bawstats_mapimage/1/uk12;nz10;us14;ca2;th3;cl6;ci2;ci1;au5;nl24;jp18
 * will map the given domain values to the world map.
 *
 */

// we need this, but I'm not sure why we don't get it by default?
include_once('includes/image.gd.inc');

function baw_map_image_drupal($dataref=1,$clist='') {

  //if we don't have GD2 functions, we can't generate the image
  if (!function_exists('imagecreatetruecolor')) return;

  if (($dataref>3)||($dataref<1)) $dataref=1;

  if (strlen($clist)>0) {

    $dommap = array();

    $dommap['uk'] = array(266,88);
    $dommap['au'] = array(485,224);
    $dommap['nz'] = array(545,251);
    $dommap['be'] = array(276,95);
    $dommap['es'] = array(262,116);
    $dommap['pt'] = array(256,117);
    $dommap['ad'] = array(271,111);
    $dommap['it'] = array(289,111);
    $dommap['fr'] = array(272,103);
    $dommap['ie'] = array(257,90);
    $dommap['nl'] = array(277,92);
    $dommap['de'] = array(284,94);
    $dommap['pl'] = array(292,91);
    $dommap['lu'] = array(276,97);
    $dommap['ch'] = array(283,102);
    $dommap['at'] = array(287,102);
    $dommap['gr'] = array(304,118);
    $dommap['al'] = array(300,114);
    $dommap['cs'] = array(299,109);
    $dommap['ba'] = array(296,108);
    $dommap['mk'] = array(303,114);
    $dommap['bg'] = array(307,110);
    $dommap['ro'] = array(309,105);
    $dommap['hu'] = array(300,102);
    $dommap['sk'] = array(300,99);
    $dommap['cz'] = array(292,97);
    $dommap['pl'] = array(296,91);
    $dommap['dk'] = array(283,83);
    $dommap['va'] = array(288,112);
    $dommap['tr'] = array(321,117);
    $dommap['ua'] = array(320,97);
    $dommap['by'] = array(312,88);
    $dommap['lt'] = array(304,86);
    $dommap['lv'] = array(305,81);
    $dommap['ee'] = array(308,77);
    $dommap['fi'] = array(310,65);
    $dommap['se'] = array(296,64);
    $dommap['no'] = array(281,72);
    $dommap['is'] = array(241,62);
    $dommap['cy'] = array(321,125);
    $dommap['sy'] = array(329,125);
    $dommap['il'] = array(325,129);
    $dommap['ps'] = array(325,130);
    $dommap['jo'] = array(326,132);
    $dommap['sa'] = array(339,142);
    $dommap['iq'] = array(340,130);
    $dommap['ir'] = array(358,130);
    $dommap['kw'] = array(344,135);
    $dommap['bh'] = array(348,140);
    $dommap['qa'] = array(350,141);
    $dommap['ae'] = array(355,144);
    $dommap['om'] = array(358,148);
    $dommap['ye'] = array(345,157);
    $dommap['eg'] = array(316,140);
    $dommap['pk'] = array(372,135);
    $dommap['af'] = array(368,125);
    $dommap['tm'] = array(364,119);
    $dommap['uz'] = array(365,111);
    $dommap['kz'] = array(371,97);
    $dommap['kg'] = array(379,112);
    $dommap['ti'] = array(378,116);
    $dommap['in'] = array(391,152);
    $dommap['np'] = array(402,137);
    $dommap['bd'] = array(411,143);
    $dommap['lk'] = array(396,171);
    $dommap['bt'] = array(412,137);
    $dommap['mm'] = array(419,146);
    $dommap['la'] = array(431,151);
    $dommap['vn'] = array(435,149);
    $dommap['kh'] = array(435,162);
    $dommap['th'] = array(431,159);
    $dommap['my'] = array(430,177);
    $dommap['sg'] = array(433,180);
    $dommap['ph'] = array(462,162);
    $dommap['id'] = array(459,185);
    $dommap['ti'] = array(468,197);
    $dommap['tw'] = array(460,144);
    $dommap['cn'] = array(433,120);
    $dommap['mm'] = array(411,92);
    $dommap['ru'] = array(399,64);
    $dommap['kr'] = array(471,121);
    $dommap['kp'] = array(469,115);
    $dommap['jp'] = array(490,120);
    //TODO polynesia
    $dommap['gl'] = array(204,27);
    $dommap['ca'] = array(103,76);
    $dommap['us'] = array(107,116);
    $dommap['bm'] = array(160,132);
    $dommap['mx'] = array(108,145);
    $dommap['cu'] = array(145,149);
    $dommap['gt'] = array(126,156);
    $dommap['bz'] = array(129,155);
    $dommap['hn'] = array(134,160);
    $dommap['sv'] = array(128,161);
    $dommap['ni'] = array(136,163);
    $dommap['cr'] = array(138,169);
    $dommap['pa'] = array(145,170);
    $dommap['co'] = array(152,176);
    $dommap['ve'] = array(165,170);
    $dommap['gy'] = array(175,174);
    $dommap['sr'] = array(182,177);
    $dommap['gf'] = array(186,177);
    $dommap['pe'] = array(151,196);
    $dommap['ec'] = array(147,183);
    $dommap['br'] = array(189,197);
    $dommap['bo'] = array(170,212);
    $dommap['py'] = array(176,218);
    $dommap['uy'] = array(182,235);
    $dommap['cl'] = array(158,231);
    $dommap['ar'] = array(168,235);
    $dommap['fk'] = array(177,274);
    $dommap['ly'] = array(293,135);
    $dommap['tn'] = array(284,124);
    $dommap['dz'] = array(174,128);
    $dommap['ma'] = array(258,130);
    $dommap['eh'] = array(249,139);
    $dommap['mr'] = array(252,152);
    $dommap['ml'] = array(263,154);
    $dommap['ne'] = array(282,155);
    $dommap['td'] = array(304,158);
    $dommap['sd'] = array(316,154);
    $dommap['et'] = array(331,165);
    $dommap['er'] = array(330,156);
    $dommap['dj'] = array(336,162);
    $dommap['sn'] = array(246,159);
    $dommap['gm'] = array(244,160);
    $dommap['gw'] = array(246,163);
    $dommap['gn'] = array(248,163);
    $dommap['sl'] = array(250,168);
    $dommap['lr'] = array(255,172);
    $dommap['ci'] = array(260,170);
    $dommap['gh'] = array(267,169);
    $dommap['bf'] = array(266,163);
    $dommap['bj'] = array(273,176);
    $dommap['ng'] = array(276,167);
    $dommap['tg'] = array(174,167);
    $dommap['cm'] = array(288,174);
    $dommap['cf'] = array(299,170);
    $dommap['so'] = array(343,173);
    $dommap['ke'] = array(325,183);
    $dommap['cd'] = array(309,186);
    $dommap['ug'] = array(319,183);
    $dommap['rw'] = array(319,188);
    $dommap['bi'] = array(319,190);
    $dommap['tz'] = array(325,194);
    $dommap['ao'] = array(298,200);
    $dommap['zm'] = array(313,204);
    $dommap['mz'] = array(329,202);
    $dommap['mw'] = array(323,204);
    $dommap['zw'] = array(315,212);
    $dommap['bw'] = array(305,221);
    $dommap['na'] = array(296,216);
    $dommap['za'] = array(306,230);
    $dommap['sz'] = array(317,227);
    $dommap['mg'] = array(343,212);

    $dommap['com'] = array(42,158);
    $dommap['net'] = array(42,188);
    $dommap['org'] = array(42,218);
    $dommap['info'] = array(42,248);

    // Set headers
    header('Expires: Mon, 01 Jan 1997 05:00:00 GMT');
    header('Cache-Control: no-store, no-cache, must-revalidate');
    header('Cache-Control: post-check=0, pre-check=0', false);
    header('Pragma: no-cache');

    header('Content-type: image/png');

    $imageFile = drupal_get_path('module', 'bawstats').'/icons/wmap.png';
    $im = image_gd_open($imageFile,substr($imageFile,-3));
    imagealphablending($im,true);

    $mapX = imagesx($im);
    $mapY = imagesy($im);

    if ($dataref == 1) $imageFile = drupal_get_path('module', 'bawstats').'/icons/circ-blue.png';
    if ($dataref == 2) $imageFile = drupal_get_path('module', 'bawstats').'/icons/circ-green.png';
    
    $crc = image_gd_open($imageFile,substr($imageFile,-3));
    imagealphablending($crc,true);

    $crcX = imagesx($crc);
    $crcY = imagesy($crc);

    $maxnum = 0;
    $rawdoms = explode(';',$clist);
    $doms = array();

    foreach ($rawdoms as $dom) {

      $chk = substr($dom,2,1);
      if (is_numeric($chk)) {
        $code = substr($dom,0,2);
        $val  = intval(substr($dom,2));
      } else { 
        $chk = substr($dom,3,1);
        if (is_numeric($chk)) {
          $code = substr($dom,0,3);
          $val  = intval(substr($dom,3));
        } else {
          $code = substr($dom,0,4);
          $val  = intval(substr($dom,4));
        }
      }
      if (isset($dommap[$code])&&($val>0)) {
        $doms[$code] = $val;
        if ($val>$maxnum) $maxnum = $val;
      }
    }

    $maxcirc = 50;
    $mincirc = 5;

    foreach ($doms as $dom => $val) {
      $pc = ($val/$maxnum);
      if ($pc>=0.05) {  // 5% of the largest cut-off
        $scz = $mincirc + ($pc*($maxcirc-$mincirc));
        imagecopyresampled($im,$crc,$dommap[$dom][0]-($scz/2),$dommap[$dom][1]-($scz/2),0,0,$scz,$scz,$crcX,$crcY);
      }
    }
    //output image to browser
    imagepng($im);
    imagedestroy($im);
  }
}
