<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats
 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// var declaration
$BAW_LOGTYPE = 'W'; // fix to weblog only for now, no email / FTP
$BAW_CURR = array(); // holds all global values of the current session
$BAW_CURR['thismonth'] = array('hits'=> 0);
$BAW_CONF['max_percent'] = 'layout_percent';
$BAW_CONF['max_bytes'] = 'layout_bytes';
$BAW_D = array();

// include files
include_once('./config.php');

if ($BAW_CONF['debug']) {
    error_reporting(E_ALL);
}

if (!defined ('XHTML')) {
    define('XHTML', $BAW_CONF['xhtml']);
}
include_once('./core/helpers.inc.php');
// start time calculation
$BAW_TIME['start'] = baw_mtime();
include_once('./modules/render_htmlchart.inc.php');
include_once('./modules/render_table.inc.php');
include_once('./modules/render_jpgraph.inc.php');
include_once('./core/data.inc.php');
include_once('./core/library.inc.php');
include_once('./core/display_helpers.php');
include_once('./core/display.inc.php');
include_once("./core/extras.inc.php");


// get input from forms
// it is questionable if this needs to be slashed or filtered since we dont write any data
if (isset($_GET['year'])) {
    $BAW_CURR['year'] = $_GET['year'];
} else {
    $BAW_CURR['year'] = date('Y');
}
if (isset($_GET['month'])) {
    $BAW_CURR['month'] = $_GET['month'];
} else {
    $BAW_CURR['month'] = date('m');
}
$BAW_CURR['day'] = date('d');
$BAW_CURR['monthyear'] = $BAW_CURR['month'].$BAW_CURR['year'];
if (isset($_GET['site'])) {
    $BAW_CURR['site_name'] = $_GET['site'];
}
$BAW_MES = baw_set_language();
if (!isset($BAW_MES['e'])) {
    $BAW_MES['e'] = 'utf-8';
}
// add language-dependent library values
$BAW_LIB['domains']['unknown'] = $BAW_MES[0];
$BAW_LIB['domains']['ip'] = $BAW_MES[0];
$BAW_LIB['os']['list']['Unknown'] = $BAW_MES[0];
$BAW_LIB['browser']['names']['Unknown'] = $BAW_MES[0];
$BAW_LIB['browser']['icons']['Unknown'] = 'unknown';
include_once('./core/config_default.inc.php');

if (isset($_REQUEST['action'])) { // used by poll and config editor
    $action = 'baw_action_' . $_REQUEST['action'];
    $out = baw_site_header()
        . $action() . baw_site_footer();
} else if (@$BAW_CURR['site_name'] == 'all_months') {
    $settings['section'] = "months";
    $out = baw_display_index($settings);
} else if (@$BAW_CURR['site_name'] == 'all_days') {
    $settings['section'] = "days";
    $out = baw_display_index($settings);
} else {
    $out = baw_display_index();
}

echo $out;
?>