<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'render_jpgraph.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

function baw_render_jpgraph ($name, $chart, $format, $type='bar', $get_avg=false, $top_x=false, $sort=0) {
    global $BAW_CONF, $BAW_MES;
    $dir = $BAW_CONF['jpgraph_path'] . '/jpgraph.php';

    if (!file_exists($dir)) {
        return baw_raise_error('jpgraph_path', array($dir));
    }
    include_once ($dir);

    // remap array for graph
    $jp_data = array();
    $jp_legend = array();
    $out = '';
    $entries = 0;
    if (count($chart) == 0) {
        return "";
    }
    foreach ($chart as $id => $data) {
        $count = count($data);
        if ($entries < $top_x) {
            $jp_legend[] = $id;
            for ($i=0; $i<$count; $i++) {
                $jp_data[$i][] = $data[$i];
            }
        } else {
            $jp_legend[$top_x] = $BAW_MES[2];
            for ($i=0; $i<$count; $i++) {
                @$jp_data[$i][$top_x] += $data[$i];
            }
        }
        $entries ++;
    }
    // $count = count($jp_data);

    include_once ($BAW_CONF['jpgraph_path'] . '/jpgraph.php');
    switch($type){
        case 'bar':
            include_once ($BAW_CONF['jpgraph_path'] . '/jpgraph_bar.php');
        break;
        case 'pie':
            include_once ($BAW_CONF['jpgraph_path'] . "/jpgraph_pie.php");
            $size = 0.17;
            $graph = new PieGraph(600,250,"auto");
            for ($i=0; $i<$count; $i++) {
                $p1 = new PiePlot($jp_data[$i]);
                if ($i == 0) {
                    $p1->SetLegends($jp_legend);
                }
                $p1->title->Set($format[$i]);
                $p1->SetSize($size);
                $vert = 0.15 + (($size + 0.1) * $i);
                $p1->SetCenter($vert,0.3);
                $p1->SetStartAngle(0);
                $p1->SetTheme("sand");
                $graph->Add($p1);
            }
            $out .= "<img src=\"{$BAW_CONF['jpgraph_temp_url']}/$name.png\">";
            $filename = $BAW_CONF['jpgraph_temp'] . "/$name.png";
            if (is_writable($BAW_CONF['jpgraph_temp'])) {
                $graph->Stroke($filename);
            } else {
                if (!file_exists($BAW_CONF['jpgraph_temp'])) {
                    return baw_raise_error('jpgraph_temppath_exists', array($BAW_CONF['jpgraph_temp']));
                }
                return baw_raise_error('jpgraph_temppath_writable', array($filename));
            }
            break;
        case 'line':
            include_once ($BAW_CONF['jpgraph_path'] . "/jpgraph_line.php");
        break;
    }
    return $out;
}
?>