<?php
// ATTENTION:
// BetterAWstats has an online config editor that you can use instead of
// editing this file here. The link is on the bottom of the menu! To use it,
// set $BAW_CONF['online_config'] = true;

//*********************************************************/
//*          SITE SETTINGS
//*********************************************************/

// NAME:    Path to AWStats Data
// INFO:    Set this value to the directory where AWStats saves its database
//          files into.ATTENTION: If you read those files on windows but have
//          them created on linux or the other way round, make sure you transfer
//          them 'BINARY'. Otherwise they cannot be read properly. No trailing
//          slash
// DEFAULT: '/path/to/betterawstats/awstats/data'
$BAW_CONF['path_data'] = '/path/to/betterawstats/awstats/data';

// NAME:    Path to AWStats Libraries
// INFO:    Set this value to the directory where AWStats saves its library
//          files into. No trailing slash
// DEFAULT: '/path/to/betterawstats/awstats/lib'
$BAW_CONF['path_lib'] = '/path/to/betterawstats/awstats/lib';

// NAME:    Path to AWStats Language files
// INFO:    Set this value to the directory where AWStats saves its language
//          files into. No trailing slash
// DEFAULT: '/path/to/betterawstats/awstats/lang'
$BAW_CONF['path_lang'] = '/path/to/betterawstats/awstats/lang';

// NAME:    Script URL
// INFO:    The url of BetterAWstats, No trailing slash
// DEFAULT: 'http://awstats.local'
$BAW_CONF['site_url'] = 'http://awstats.local';

// NAME:    AWStats Icons URL
// INFO:    The url to the awstats icons, should include the whole http://...,no
//          trailing slash
// DEFAULT: '$BAW_CONF['site_url'] . '/awstats/icon''
$BAW_CONF['icons_url'] = 'http://awstats.local/awstats/icon';

// NAME:    Web Configuration
// INFO:    Enable the online configuator?
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['online_config'] = true;



//*********************************************************/
//*          LAYOUT SETTINGS
//*********************************************************/

// NAME:    Layout Type
// INFO:    Display page in vertical or horizontal layout?
// DEFAULT: 'style'
// POSSIBLE VALUES: 'style', 'compact'
$BAW_CONF['layout_type'] = 'style';

// NAME:    Language
// INFO:    Set your language. First available language accepted by browser=auto
// DEFAULT: 'auto'
// POSSIBLE VALUES: 'auto', 'al', 'ba', 'bg', 'ca', 'tw', 'cn', 'cz', 'dk', 'nl',
//                  'en', 'et', 'eu', 'fi', 'fr', 'gl', 'de', 'gr', 'he', 'hu',
//                  'is', 'id', 'it', 'jp', 'kr', 'lv', 'nn', 'nb', 'pl', 'pt',
//                  'br', 'ro', 'ru', 'sr', 'sk', 'es', 'se', 'tr', 'ua', 'wlk'
$BAW_CONF['lang_setting'] = 'auto';

// NAME:    First day of the week
// INFO:    Should Sunday be the first day of the week or monday?
// DEFAULT: '1'
// POSSIBLE VALUES: '1', '2'
$BAW_CONF['firstdayofweek'] = '1';

// NAME:    Decimal Point
// INFO:    Decimal Point Character (99.9)
// DEFAULT: '.'
$BAW_CONF['dec_point'] = '.';

// NAME:    Thousands separator
// INFO:    Thousand Digit separator (1'000)
// DEFAULT: '''
$BAW_CONF['tho_point'] = "'";

// NAME:    Percentage decimals
// INFO:    How many decimals for percentage value? (99.9%)
// DEFAULT: '1'
$BAW_CONF['percent_decimals'] = '1';

// NAME:    XHTML/ HTML
// INFO:    Do you want output in HTML or XHTML?
// DEFAULT: ' '
// POSSIBLE VALUES: ' ', '/'
$BAW_CONF['xhtml'] = ' ';

// NAME:    Field Length
// INFO:    What is the max. length of table fields?
// DEFAULT: '65'
$BAW_CONF['field_length'] = '65';

// NAME:    Max. Table Lines
// INFO:    What is the max. no. of lines a table can have? Set to false to
//          disable
// DEFAULT: '10000'
$BAW_CONF['maxlines'] = '10000';

// NAME:    Hide Empty data
// INFO:    Completely hide graps with zero entries? (The menu will always show
//          the entry)
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['hideempty'] = true;



//*********************************************************/
//*          CHART SETTINGS
//*********************************************************/

// NAME:    Max scale for Visitors
// INFO:    The maximum of the chosen will define the maximum height of the
//          Visitors
// DEFAULT: 'layout_visits'
// POSSIBLE VALUES: 'layout_visitos', 'layout_visits', 'layout_pages',
//                  'layout_hits', 'layout_bytes'
$BAW_CONF['max_visitors'] = 'layout_visits';

// NAME:    Max scale for Visits
// INFO:    The maximum of the chosen will define the maximum height of the
//          Visits
// DEFAULT: 'layout_visits'
// POSSIBLE VALUES: 'layout_visits', 'layout_pages', 'layout_hits', 'layout_bytes'
$BAW_CONF['max_visits'] = 'layout_visits';

// NAME:    Max scale for PAges
// INFO:    The maximum of the chosen will define the maximum height of the
//          Pages
// DEFAULT: 'layout_pages'
// POSSIBLE VALUES: 'layout_pages', 'layout_hits', 'layout_bytes'
$BAW_CONF['max_pages'] = 'layout_pages';

// NAME:    Max scale for Hits
// INFO:    The maximum of the chosen will define the maximum height of the Hits
// DEFAULT: 'layout_hits'
// POSSIBLE VALUES: 'layout_hits', 'layout_bytes'
$BAW_CONF['max_hits'] = 'layout_hits';

// NAME:    Include Zero-Values in averages
// INFO:    Include chart entries that have 0 hits into the average calculation?
//          (After the first set with data, following 0-values will count!)
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['avg_zero'] = false;



//*********************************************************/
//*          ADVANCED SETTINGS
//*********************************************************/

// NAME:    Debug
// INFO:    Do you want to show debug-output?
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['debug'] = false;

// NAME:    Time Info
// INFO:    Do you want to show detailed time-info for progress?
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['show_time'] = false;

// NAME:    Parser Stats
// INFO:    Do you want to show detailed Logfile Parsing stats?
// DEFAULT: 'false'
// POSSIBLE VALUES: 'true', 'false'
$BAW_CONF['show_parser_stats'] = true;

// NAME:    Module settings
// INFO:    Are you using BetterAWstats as a module for another software? (This
//          is not working yet)
// DEFAULT: 'false'
// POSSIBLE VALUES: 'false'
$BAW_CONF['module'] = false;



//*********************************************************/
//*          DISPLAY
//*********************************************************/

// NAME: Summary
// INFO: General Overview of key figures and dates
$BAW_CONF_DIS['overview'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 1,
);

// NAME: Monthly history
// INFO: Monthly data
$BAW_CONF_DIS['months'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 2,
    'showmonths' => 24,
    'avg' => true,
    'total' => true,
    'chart' => true,
    'table' => true,
);

// NAME: Days of month
// INFO: Daily data
$BAW_CONF_DIS['days'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 3,
    'avg' => true,
    'total' => true,
    'chart' => true,
    'table' => true,
);

// NAME: Days of week
// INFO: Weekdays
$BAW_CONF_DIS['weekdays'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 4,
    'avg' => true,
    'total' => false,
    'chart' => true,
    'table' => true,
);

// NAME: Hours
// INFO: Hours of the day
$BAW_CONF_DIS['hours'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 5,
    'avg' => true,
    'total' => false,
    'chart' => true,
    'table' => true,
    'sort' => 0,
    'sort_dir' => SORT_ASC,
);

// NAME: Visitors domains/countries
// INFO: Domains of visitors
$BAW_CONF_DIS['domains'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 6,
    'avg' => false,
    'total' => false,
    'chart' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 3,
    'sort_dir' => SORT_DESC,
);

// NAME: Hosts
// INFO: IP addresses of visitors
$BAW_CONF_DIS['visitors'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 7,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
    'hidebots' => false,
);

// NAME: Authenticated users
// INFO: Logins for username/password protected pages
$BAW_CONF_DIS['logins'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 8,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 5,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Robots/Spiders visitors
// INFO: Spiders, Robots of Search engines etc.
$BAW_CONF_DIS['robots'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 9,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Worms
// INFO: Worms searching for security holes
$BAW_CONF_DIS['worms'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 10,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 2,
    'sort_dir' => SORT_DESC,
);

// NAME: Visits duration
// INFO: How long have people been on the site?
$BAW_CONF_DIS['sessions'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 11,
    'avg' => false,
    'total' => false,
    'table' => true,
);

// NAME: File type
// INFO: What filetypes are on the site
$BAW_CONF_DIS['filetype'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 12,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'chart' => true,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Pages-URL
// INFO: Pages on the site
$BAW_CONF_DIS['urls'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 13,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Operating Systems
// INFO: Operating system of users
$BAW_CONF_DIS['os'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 14,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 2,
    'sort_dir' => SORT_DESC,
);

// NAME: Unknown OS (useragent field)
// INFO: Unknown Operating system
$BAW_CONF_DIS['unknownos'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 16,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Operating Systems (+Versions)
// INFO: Operating system of users including versions
$BAW_CONF_DIS['osversions'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 15,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Browsers
// INFO: Browsers of Users
$BAW_CONF_DIS['browsers'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 17,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 3,
    'sort_dir' => SORT_DESC,
);

// NAME: Browsers (+Versions)
// INFO: Browsers of Users {$BAW_MES[21]} (+{$BAW_MES[58]})
$BAW_CONF_DIS['browserversions'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 18,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 4,
    'sort_dir' => SORT_DESC,
);

// NAME: Unknown browsers (useragent field)
// INFO: Unknown Browsers
$BAW_CONF_DIS['unknownbrowser'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 19,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Screen sizes
// INFO: Screensizes of users
$BAW_CONF_DIS['screensizes'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 20,
    'avg' => false,
    'total' => false,
    'table' => true,
    'top_x' => 5,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Referring search engines
// INFO: Referrals from search engines
$BAW_CONF_DIS['se_referers'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 21,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Referring sites
// INFO: Referrals from other sites
$BAW_CONF_DIS['referers'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 22,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Referring sites Domains
// INFO: Referrals from other sites, grouped by 2-nd level domains
$BAW_CONF_DIS['referer_domains'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 23,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Referring sites Hotlinks
// INFO: Pages linking to images/data on your site
$BAW_CONF_DIS['hotlinks'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 24,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Referring sites Hotlinks by Domain
// INFO: Domains linking to images/data on your site
$BAW_CONF_DIS['hotlink_domains'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 25,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Search&nbsp;Keyphrases
// INFO: Search phrases
$BAW_CONF_DIS['searchphrases'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 26,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Search&nbsp;Keywords
// INFO: Search words
$BAW_CONF_DIS['searchwords'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 27,
    'avg' => false,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME: Miscellaneous
// INFO: User system features
$BAW_CONF_DIS['misc'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 28,
    'table' => true,
);

// NAME: HTTP Status codes
// INFO: Acesses to pages that returned errors
$BAW_CONF_DIS['errors'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 29,
    'total' => true,
    'table' => true,
    'top_x' => 10,
    'sort' => 2,
    'sort_dir' => SORT_DESC,
);

// NAME: Error&nbsp;Hits
// INFO: Required but not found URLs (HTTP code 404)
$BAW_CONF_DIS['errors404'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 30,
    'table' => true,
    'total' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

// NAME:
// INFO:
$BAW_CONF_DIS['extra_1'] = array(
    'show' => true,
    'collapse' => false,
    'order' => 31,
    'total' => false,
    'table' => true,
    'top_x' => 10,
    'sort' => 1,
    'sort_dir' => SORT_DESC,
);

?>