<?php
/**
 * betterawstats, an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place','Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'data.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

// wrapper function for data reading
function baw_read_data() {
    global $BAW_CONF, $BAW_CURR;
    // get all files
    $dirfiles = baw_parse_dir($BAW_CONF['path_data']);
    // get a list of sites and all datafiles
    $data = baw_match_files($dirfiles);
    // read all data and create global array
    baw_read_history($data);
}

// recursive function to read the data directories
// returns ALL files found in that directory
function baw_parse_dir($dir) {
    global $BAW_CONF;
    if (!file_exists($dir)) {
        echo baw_raise_error('datafilesdir', array($dir));
        return array();
    }
    // add trailing slash if not exists
    if (substr($dir, -1) != '/') {
        $dir .= '/';
    }
    if ($BAW_CONF['debug']) {
        echo "<hr>parsing Directory $dir<br>";
    }
    $files = array();
    if ($dh = @opendir($dir)) {
        while (($file = readdir($dh)) !== false) {
            if (!preg_match('/^\./s', $file)) {
                if (is_dir($dir.$file)) {
                    $newdir = $dir.$file.'/';
                    chdir($newdir);
                    $files = array_merge($files, baw_parse_dir($newdir));
                    chdir('./..');
                    if ($BAW_CONF['debug']) {
                        echo " found directory $dir<br>";
                    }
                } else {
                    $files[] = $dir.$file;
                    if ($BAW_CONF['debug']) {
                        echo " found file $file<br>";
                    }
                }
            }
        }
    }
    if ($BAW_CONF['debug']) {
        echo " finished parsing Directory $dir<hr>";
    }
    return $files;
}

// find all files that contain the data for the current month and 12 month before now
// to write a rolling month data chart
// input array of all files to be checked
// output two arrays, one with all sites and one with all config names date and path
function baw_match_files($dirfiles) {
    global $BAW_CURR, $BAW_CONF, $BAW_CONF_DIS, $BAW_MES;
    // now find those matching the date
    $data = array(); // all config names & files
    if ($BAW_CURR['month'] == 'all') {
        $pat = '\d{2}';
    } else {
        $pat = ''; // substr('0'.$BAW_CURR['month'], -2);
    }
    // get the month & Year x month ago
    $month_back = $BAW_CONF_DIS['months']['showmonths'];
    for ($i=$month_back; $i>0; $i--) {
        $get_year = date("Y", mktime(0, 0, 0, $BAW_CURR['month']-$i, 1, $BAW_CURR['year']));
        $get_month = date("m", mktime(0, 0, 0, $BAW_CURR['month']-$i, 1, $BAW_CURR['year']));
        $pat .= "$get_month$get_year|";
    }
    $site_pat = '(.+)';
    $pat = '/awstats('.$pat.$BAW_CURR['monthyear'].')\.('.$site_pat.')\.txt$/';
    $pat_others = '/awstats(\d{6})\.('.$site_pat.')\.txt$/';
    // go through all files and find matching ones
    $year_array = array();
    $month_array = array();
    $sites = array();
    foreach ($dirfiles as $file) {
        $filename = explode("/", $file);
        $filename = $filename[count($filename)-1];
        if (preg_match($pat, $file, $match)) {
            $xdate = $match[1];
            $month = substr($xdate, 0, 2);
            $year = substr($xdate, 2, 4);
            $year_array[$year] = $year;
            //$year = substr($xdate, 2, 4);
            // the val and key are the same for the dropdown generation
            // it also prevents duplication so array_unique does not have to be
            // called
            $month_array[$month] = $BAW_MES[$month + 59];
            $site = $match[2];
            $sites[] = $site;
            //if (!$BAW_CONF['filter_configs'] || in_array($site, $BAW_CONF['filter_configs'])) {
                $data[] = array($site, $xdate, $file);
                if ($BAW_CONF['debug']) {
                    echo "<b> data found for month $month and year $year: $file, SITE: {$site}</b><br>";
                }
            //}
        } else if (preg_match($pat_others, $file, $match)) {
            $month = substr($filename, 7, 2);
            $year = substr($filename, 9, 4);
            $year_array[$year] = $year;
            $month_array[$month] = $BAW_MES[$month + 59];
        }
    }
    if (count($year_array)>0) {
        $year_array = array_unique($year_array);
        ksort($year_array);
    }
    if (count($month_array)>0) {
        ksort($month_array);
        $month_array = array_unique($month_array);
    }
    $BAW_CURR['years'] = $year_array;
    $BAW_CURR['months'] = $month_array;
    // since we added sites with each file, remove duplicates
    if (count($sites) > 0) {
        $sites = array_unique($sites);
        sort($sites);
    }
    if (!isset($BAW_CURR['site_name'])) {
        $BAW_CURR['site_name'] = $sites[0]; // we dont have a selected, take first in line
    }
    $BAW_CURR['sites'] = $sites;
    return $data;
}

function baw_calc_monthdata($date, $site) {
    global $BAW_D;
    $pages = 0;
    $hits = 0;
    $bandwidth = 0;
    $not_viewed_pages = 0;
    $not_viewed_hits = 0;
    $not_viewed_bandwidth = 0;
    $t = @$BAW_D[$site][$date]["TIME"];
    $num_t = count($t);
    for ($i=0; $i<$num_t; $i++) {
        $pages += $t[$i][1];
        $hits += $t[$i][2];
        $bandwidth += $t[$i][3];
        $not_viewed_pages += $t[$i][4];
        $not_viewed_hits += $t[$i][5];
        $not_viewed_bandwidth += $t[$i][6];
    }
    $g = @$BAW_D[$site][$date]["GENERAL"];
    $result = array(
        $g['TotalUnique'][1],
        $g['TotalVisits'][1],
        $pages,
        $hits,
        $bandwidth,
        $not_viewed_pages,
        $not_viewed_hits,
        $not_viewed_bandwidth
    );
    return $result;
}

// read data from awstats library files (perl format)
function baw_get_library($file, $data) {
    global $BAW_CONF, $BAW_LOGTYPE;
    $file = $BAW_CONF['path_lib'] . $file;
    if ($BAW_CONF['debug']) {
        echo "Trying to read library data ($data) from file: $file<br>";
    }
    if (!file_exists($file)) {
        echo baw_raise_error('libraryfiles', array($file));
        return array();
    }
    // read the whole file in one go
    $file_text = file_get_contents($file);
    // these are to attempt to convert the perl data file to PHP
    $search = array(
        "\$LogType eq 'S'",
        "= ", // remove spaces between = and (
        "@",
        "%",
        "'=>'",
        "=(",
        "=\n(",
        "=\r(",
        "=\r\n(",
        ",,"
    );
    $replace  = array(
        "\$LogType = 'S'",
        "=",
        "$",
        "$",
        "', '",
        "= array(",
        "= array(",
        "= array(",
        "= array(",
        ","
    );
    $file_text = str_replace($search, $replace, $file_text);

    $check = eval($file_text);
    // check if we have an error with the conversion
    if ($check === false) {
        echo baw_raise_error('libraryeval', array($file, $data));
    }
    if (is_array($data)) {
        $a = 0;
        foreach($data as $arr_name) {
            $countpairs = count($$arr_name);
            $parr = $$arr_name;
            for ($i=0; $i<$countpairs; $i=$i+2) {
                $new_arr[$a][$parr[$i]] = $parr[$i+1];
            }
            $a++;
        }
    } else {
        $countpairs = count($$data);
        $parr = $$data;
        for ($i=0; $i<$countpairs; $i=$i+2) {
            $new_arr[$parr[$i]] = $parr[$i+1];
        }
    }
    return $new_arr;
}

// read the actual data from the files
function baw_read_history($data) {
    global $BAW_D, $BAW_CONF, $BAW_LIB, $BAW_CURR;
    // ini_set('auto_detect_line_endings', '0');
    $MAP = array();
    $br_arr = array("\n", "\r", "\r\n");
    if ($BAW_CURR['month'] !== '01') {
        $prevyear = $BAW_CURR['year'];
        $prevmonth = sprintf('%02d',$BAW_CURR['month']-1);
    } else {
        $prevyear = $BAW_CURR['year']-1;
        $prevmonth = '12';
    }
    $allsites = false;
    if ($BAW_CURR['site_name'] == 'all_months' or $BAW_CURR['site_name'] == 'all_days') {
        $allsites = true;
    }
    // iterate each data file
    foreach ($data as $file_arr) {
        $site = $file_arr[0];
        // only take relevant ones
        if ($site == $BAW_CURR['site_name'] or $allsites) {
            $date = $file_arr[1];
            $file = $file_arr[2];
            if ($BAW_CONF['debug']) {
                echo "reading site $site datafile, date $date, file $file<br>";
            }
            // choose data set
            if ($BAW_CURR['site_name'] == 'all_months') {
                $BAW_DATA_X = $BAW_LIB['data']['all_months'];
            } else if ($BAW_CURR['site_name'] == 'all_days') {
                $BAW_DATA_X = $BAW_LIB['data']['all_days'];
            } else if ($date == $BAW_CURR['monthyear']) {
                $BAW_DATA_X = $BAW_LIB['data']['full'];
            } else if ($date == $prevmonth.$prevyear) {
                $BAW_DATA_X = $BAW_LIB['data']['prevmonth'];
            } else {
                $BAW_DATA_X = $BAW_LIB['data']['month'];
            }
            echo baw_timereport("reading file start $file");
            // open the file
            $f = fopen($file, 'r');
            // first get the block of offsets from the beggining
            $str ='';
            $check = 1;
            // read this file until we hit the offsets
            while ($check !== 0) {
                $str = fgets($f, 20000);
                $check = strpos($str, 'BEGIN_MAP');
            }
            $check = explode(' ', $str);
            $lines_count = $check[1]; // line length of the map
            if ($BAW_CONF['debug']) {
                echo "found data map for $file, has $lines_count lines<br>";
            }
            // now read x more lines
            for ($i=0; $i<$lines_count;$i++) { // read the complete offset map
                $str = fgets($f, 512);
                // split the info in string - byte offset
                $check = explode(' ', $str);
                $type = substr($check[0], 4);
                $offset = $check[1];
                if ($offset > 1) {
                    if ($BAW_CONF['debug']) {
                        echo "data type $type, starts at offset $offset ($file)<br>";
                    }
                    $OFFSET[$type] = $offset;
                } else {
                    echo baw_raise_error('datafileindex', $err_data);
                    exit;
                }
            }
            echo baw_timereport("reading offset index end");
            $filedata = array();
            if ($BAW_CONF['debug']) {
                echo "map read, reading data now<br>";
            }
            // iterate only those values that are in the datafile
            foreach ($OFFSET as $type => $offset) {
                // and only those of the available that we want
                if (isset($BAW_DATA_X[$type])) {
                    fseek($f , $offset, SEEK_SET);
                    $check = 1;
                    while ($check !== 0) {
                        $firstline = fgets($f, 20000);
                        $check = strpos($firstline,"BEGIN_$type");
                    }
                    if ($check !== 0) {
                        $err_data = array($file, $firstline);
                        echo baw_raise_error('datafile', $err_data);
                        exit;
                    }
                    $index = explode(' ', $firstline);
                    $lines_count = $index[1];
                    if ($BAW_CONF['debug']) {
                        echo "data $type found, is $lines_count lines long, reading now, one . per line indicator:<br>";
                    }
                    for ($i=0; $i<$lines_count;$i++) {
                        if ($BAW_CONF['debug']) {
                            echo ".";
                        }
                        $str = fgets($f, 20000);
                        // remove linebreaks from string
                        foreach ($br_arr as $linebreak) {
                            $str = str_replace($linebreak, '', $str);
                        }
                        $line_arr = explode(' ', $str);
                        // shift first element as array name
                        $first_element = $line_arr[0];
                        // settype($first_element,'string');
                        $filedata[$type][$first_element] = $line_arr;
                    }
                    if ($BAW_CONF['debug']) {
                        echo "<br>all data read for $type<br>";
                    }
                }
            }
            echo baw_timereport("data parse end");
            $BAW_D[$site][$date] = $filedata;
            fclose($f);
            if ($BAW_CONF['debug']) {
                echo "data read, file closed<br>";
            }
        }
    }
}

function baw_read_lng_data($file) {
    global $BAW_CONF;
    $r = array();
    if ($BAW_CONF['debug']) {
        echo "<hr> reading language data: $file<br>";
    }
    $lines = file($file);
    foreach ($lines as $line) {
        $check = strpos ($line, '#');
        if ($check !== 0) {
            $match = explode('=', $line);
            $match[0] = substr($match[0], 7);
            $r[$match[0]] = trim($match[1]);
        }
    }
    if ($BAW_CONF['debug']) {
        echo " finished reading language data<hr>";
    }
    return $r;
}

// get the name of the site from the datafile
function baw_get_sitename($file) {
    global $BAW_CONF;
    $r = '';
    if ($BAW_CONF['debug']) {
        echo "<hr>getting config<br>";
    }
    if (preg_match('/awstats\d{6}\.(.+)\.txt/', $file, $match)) {
        $r = $match[1];
    }
    if ($BAW_CONF['debug']) {
        echo " found match $r<hr>";
    }
    return $r;
}

?>