<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'display.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

function baw_display_overview($set) {
    global $BAW_D, $BAW_MES, $BAW_CURR, $BAW_CONF;
    $m = $BAW_MES;
    $m_name = $m[59+$BAW_CURR['month']];
    $o = baw_calc_monthdata($BAW_CURR['monthyear'],$BAW_CURR['site_name']);
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]["GENERAL"])) {
        $g = @$BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]["GENERAL"];
        $l = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]["GENERAL"]['LastUpdate'];
        $time = baw_time_format($l[1]);
        $BAW_CURR['thismonth']['hits'] = $o[1];
        $out = "<table class=\"datatable\">\n"
            . "    <tr>\n        <td><b>{$m[133]}</b></td><td colspan=\"5\">{$m[5]} $m_name {$BAW_CURR['year']}</td>\n    </tr>\n"
            . "    <tr class=\"layout_index\">\n        <td><b>{$m[8]}</b></td><td colspan=\"5\">".baw_time_format($g['FirstTime'][1])."</td>\n    </tr>\n"
            . "    <tr class=\"layout_index\">\n        <td><b>{$m[9]}</b></td><td colspan=\"5\">".baw_time_format($g['LastTime'][1])."</td>\n    </tr>\n"
            . "    <tr>\n        <td>&nbsp;</td>\n"
            ."        <th class=\"layout_visitors\" onmouseover=\"ShowTip(2);\" onmouseout=\"HideTip(2);\">{$m[11]}</th>\n"
            ."        <th class=\"layout_visits\" onmouseover=\"ShowTip(1);\" onmouseout=\"HideTip(1);\">{$m[10]}</th>\n"
            ."        <th class=\"layout_pages\" onmouseover=\"ShowTip(3);\" onmouseout=\"HideTip(3);\">{$m[56]}</th>\n"
            ."        <th class=\"layout_hits\" onmouseover=\"ShowTip(4);\" onmouseout=\"HideTip(4);\">{$m[57]}</th>\n"
            ."        <th class=\"layout_bytes\" onmouseover=\"ShowTip(5);\" onmouseout=\"HideTip(5);\">{$m[75]}</th>\n    </tr>\n"

            . "    <tr style=\"white-space:nowrap;\">\n        <td>{$m[160]}&nbsp;*</td>\n"
            ."        <td><b>".baw_num_format($o[0])."</b><br>&nbsp;</td>\n"
            ."        <td><b>".baw_num_format($o[1])."</b><br>(".@baw_num_format($o[1] / $o[0],2)."&nbsp;{$m[52]})</td>\n"
            ."        <td><b>".baw_num_format($o[2])."</b><br>(".@baw_num_format($o[2] / $o[1],2)."&nbsp;{$m[27]}/{$m[12]})</td>\n"
            ."        <td><b>".baw_num_format($o[3])."</b><br>(".@baw_num_format($o[3] / $o[1],2)."&nbsp;{$m[57]}/{$m[12]})</td>\n"
            ."        <td><b>".baw_byte_format($o[4])."</b><br>(".@baw_byte_format($o[4] / $o[1],2)."/{$m[12]})</td>\n    </tr>\n"
            . "    <tr>\n        <td>{$m[161]}&nbsp;*</td>\n"
            ."        <td colspan=\"2\">&nbsp;<br>&nbsp;</td>\n"
            ."        <td><b>".baw_num_format($o[5])."</b></td>\n"
            ."        <td><b>".baw_num_format($o[6])."</b></td>\n"
            ."        <td><b>".baw_byte_format($o[7])."</b></td></tr>\n"
            . "    <tr>\n        <td colspan=\"6\">* {$m[159]}</td>\n    </tr>\n";
        if ($BAW_CONF['show_parser_stats']) {
            $out .= "    <tr>\n        <td colspan=\"6\"><b>Data File Update Stats:</b></td>\n    </tr>\n"
            . "    <tr>\n"
            ."        <td>{$BAW_MES[35]}:<br> $time</td>\n"
            ."        <td>Parsed records:<br> " . baw_num_format($l[2]) . "</td>\n"
            ."        <td>Old records:<br> " . baw_num_format($l[3]) . "</td>\n"
            ."        <td>New records:<br> " . baw_num_format($l[4]) . "</td>\n"
            ."        <td>Corrupted:<br> " . baw_num_format($l[5]) . "</td>\n"
            ."        <td>Dropped:<br> " . baw_num_format($l[6]) . "</td>\n    </tr>\n";
        }
        $out .= "</table>\n\n";
    } else {
        $out = "$m_name-{$BAW_CURR['year']} has no data";
    }
    return $out;
}

function baw_display_months($set) {
    global $BAW_MES, $BAW_CONF, $BAW_CURR;
    $format = array(
        0 => array ('format' => 'layout_text', 'title'=> $BAW_MES[5]), // first cell in first line
        1 => array ('format' => 'layout_visitors', 'title'=> $BAW_MES[11], 'onmouseover' => 'ShowTip(2);', 'onmouseout' => 'HideTip(2);'),
        2 => array ('format' => 'layout_visits', 'title'=> $BAW_MES[10], 'onmouseover' => 'ShowTip(1);', 'onmouseout' => 'HideTip(1);'),
        3 => array ('format' => 'layout_pages', 'title'=> $BAW_MES[56], 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        4 => array ('format' => 'layout_hits', 'title'=> $BAW_MES[57], 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        5 => array ('format' => 'layout_bytes', 'title'=> $BAW_MES[75], 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);')
    );
    $allsites = false;
    if ($BAW_CURR['site_name'] !== 'all_months') {
        $sites = array($BAW_CURR['site_name']);
    } else {
        $sites = $BAW_CURR['sites'];
        $allsites = true;
    }
    $html = '';
    // for each month, get the four data sets
    $frm_arr = array('layout_visitors', 'layout_visits', 'layout_pages', 'layout_hits', 'layout_bytes');
    foreach ($sites as $site) {
        $data_format = array();
        $x = 0;
        $val = array();
        $monthback = $set['showmonths'] - 1;
        $chart = array();
        for ($i=$monthback; $i>=0; $i--){
            // get the month & Year x month ago
            $tyear = date("Y", mktime(0, 0, 0, $BAW_CURR['month']-$i, 1, $BAW_CURR['year']));
            $tmonth = date("m", mktime(0, 0, 0, $BAW_CURR['month']-$i, 1, $BAW_CURR['year']));
            // get the data for that month
            $data = baw_calc_monthdata($tmonth.$tyear, $site);
            $x++;
            $month_text = $tmonth + 59;
            $class = '';
            $date = date("Ym", mktime(0,0,0,$tmonth,1,$tyear));
            $today = date("Ym");
            if ($date == $today) {
                $class = "currentday";
            }
            if (!isset($from)) {
                $from = "{$BAW_MES[$month_text]}-$tyear";
            }
            $to = "{$BAW_MES[$month_text]}-$tyear";
            for ($j=0; $j<5; $j++) {
                $chart["{$BAW_MES[$month_text]}<br>$tyear"][] = array('data' => "$data[$j]", 'class' => "$class", 'format' => $frm_arr[$j]);
            }

            if ($class !== '') {
                $data_format[$tmonth.$tyear] = $class;
            }
            $val[$tmonth.$tyear] = array(
                "{$BAW_MES[$month_text]} $tyear",
                $data[0],
                $data[1],
                $data[2],
                $data[3],
                $data[4],
            );
        }
        if ($set['chart']) {
            if ($allsites) {
                $full_url = "{$BAW_CONF['site_url']}/index.php?site=$site&amp;month={$BAW_CURR['month']}&amp;year={$BAW_CURR['year']}";
                $html .= "<h3 id=\"site_$site\"><a href=\"$full_url\">$site</a></h3>";
                // $html .= baw_display_updatestats($site);
            }
            $html .= baw_render_htmlchart($chart, $set['avg'], false);
        }
        if ($set['table']) {
            $html .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], false, $data_format);
        }
    }
    $out = $html;
    return $out;
}

function baw_display_days($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $sum = array(0,0,0,0,0); // summ all overall data
    // this 3 lines is only for collecting data for weekdays
    $wdsum_arr = array(); // summ all weekday data
    $wdcount_arr = array(0,0,0,0,0,0,0); // count the number of sat, sun etc
    $wdavg_arr = array(); // values of avg

    // assemble date
    $daysofmonth = date("t", baw_get_timestamp("{$BAW_CURR['year']}{$BAW_CURR['month']}01000000"));
    $current_month = date('m');
    $current_day = date('d');
    $daydiff = 0;
    $data_format = array();
    // find how may days we have to go back
    if ($BAW_CURR['month'] == $current_month) { // if we have the current month, get some data from the last month
        $daydiff = abs($current_day - $daysofmonth); // calculate how many days are missing
    }
    // we have to add the days of the previous month
    if ($daydiff > 0) {
        if ($BAW_CURR['month'] !== '01') {
            $prevyear = $BAW_CURR['year'];
            $prevmonth =  sprintf('%02d', $BAW_CURR['month']-1);
            $daysoflastmonth = date("t", baw_get_timestamp("{$BAW_CURR['year']}{$prevmonth}01000000"));
        } else {
            $prevyear = $BAW_CURR['year'] - 1;
            $prevmonth = '12';
        }
    }
    $format = array(
        0 => array ('format'=> 'layout_date', 'title' => $BAW_MES[4]),
        1 => array ('format'=> 'layout_visits', 'title' => $BAW_MES[10], 'onmouseover' => 'ShowTip(1);', 'onmouseout' => 'HideTip(1);'),
        2 => array ('format'=> 'layout_pages', 'title' => $BAW_MES[56], 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        3 => array ('format'=> 'layout_hits', 'title' => $BAW_MES[57], 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        4 => array ('format'=> 'layout_bytes', 'title' => $BAW_MES[75], 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);')
    );
    // check if we do all sites or just one
    $allsites = false;
    if ($BAW_CURR['site_name'] !== 'all_days') {
        $sites = array($BAW_CURR['site_name']);
    } else {
        $sites = $BAW_CURR['sites'];
        $allsites = true;
    }
    $html = '';
    // iterate all sites, normally only one
    foreach ($sites as $site) {
        $val = array();
        // get the data for this site if available
        if (isset($BAW_D[$site][$BAW_CURR['monthyear']]['DAY'])) {
            $val = $BAW_D[$site][$BAW_CURR['monthyear']]['DAY'];
        }
        // in case we need last months data, get it too
        if ($daydiff > 0) {
            if (isset($BAW_D[$site][$prevmonth.$prevyear]['DAY'])) {
                $prevdate_data = $BAW_D[$site][$prevmonth.$prevyear]['DAY'];
                $date_cut = $prevyear . $prevmonth . $prevmonth =  sprintf('%02d', $daysoflastmonth - $daydiff);
                $val_prev = baw_cut_date_array($prevdate_data, $date_cut);
                $val = $val_prev + $val;
            }
        }
        $newval = array();
        $chart = array();
        for ($j=0; $j<$daysofmonth; $j++) {
            $class = '';
            // foreach ($val as $date => $data) {
            $date = date("Ymd", mktime(0,0,0,$BAW_CURR['month'],1+ $j - $daydiff,$BAW_CURR['year']));
            $today = date("Ymd");
            if ($date == $today) {
                $class = "currentday";
            }
            if (!isset($val[$date])) {
                $val[$date] = array(0,0,0,0,0);
            }
            $data = $val[$date];
            $xdate = $date . "000000";
            $tstamp = baw_get_timestamp($xdate);
            $wday = date("w", $tstamp);

            if ($wday == 0 or $wday == 6) {
                $class = "$class weekend";
                $class = trim($class);
            }
            // these lines is only for collecting data for weekdays
            $wdcount_arr[$wday]++;  // count no of one weekday for avg division
            for ($i=1; $i<=4; $i++) { // iterate data types
                if (!isset($wdsum_arr[$wday][$i])) {
                    $wdsum_arr[$wday][$i] = 0;
                }
                $wdsum_arr[$wday][$i] += $data[$i];
            }

            if (!isset($from)) {
                $from = $xdate;
            }
            $to = $xdate;
            $BAW_CURR['wdays']['count'] = $wdcount_arr;
            $BAW_CURR['wdays']['avg'] = $wdsum_arr;
            $BAW_CURR['wdays']['from'] = $from;
            $BAW_CURR['wdays']['to'] = $to;
            $brdate = baw_get_date_str($date, "<br>");
            $chart[$brdate][] = array('data' => $data[4], 'class' => $class, 'format' => 'layout_visits');
            $chart[$brdate][] = array('data' => $data[1], 'class' => $class, 'format' => 'layout_pages');
            $chart[$brdate][] = array('data' => $data[2], 'class' => $class, 'format' => 'layout_hits');
            $chart[$brdate][] = array('data' => $data[3], 'class' => $class, 'format' => 'layout_bytes');
            $newval[$xdate] = array($xdate, $data[4],$data[1],$data[2],$data[3]);
            if ($class !== '') {
                $data_format[$xdate] = $class;
            }
        }
        if ($set['chart']) {
            if ($allsites) {
                $full_url = "{$BAW_CONF['site_url']}/index.php?site=$site&amp;month={$BAW_CURR['month']}&amp;year={$BAW_CURR['year']}";
                $html .= "<h3 id=\"site_$site\"><a href=\"$full_url\">$site</a></h3>";
                // $html .= baw_display_updatestats($site);
            }
            $html .= baw_render_htmlchart($chart, $set['avg'], false);
        }
        if ($set['table']) {
            $html .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], false, $data_format);
        }
    }
    // $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    // Table
    $out = $html;
    return $out;
}

function baw_display_weekdays($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $format = array(
        0 => array ('title' => $BAW_MES[4], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title' => $BAW_MES[10], 'format' => 'layout_visits', 'onmouseover' => 'ShowTip(1);', 'onmouseout' => 'HideTip(1);'),
        2 => array ('title' => $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        3 => array ('title' => $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        4 => array ('title' => $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);')
    );
    // get all the averages of one weekday each
    $chart = array();
    $newval = array();
    $wdcount_arr = $BAW_CURR['wdays']['count'];
    $wdsum_arr = $BAW_CURR['wdays']['avg'];
    for ($w=0; $w<7; $w++) {
        // switch for Mo or Su start
        $x = $w;
        if ($BAW_CONF['firstdayofweek'] == 1) {
            $x = $w + 1;
            if ($x == 7) {
                $x = 0;
            }
        }
        $class = '';
        if ($x == 0 or $x == 6) {
            $class = "weekend";
        }
        if ($wdcount_arr[$x] == 0) {
            $wdcount_arr[$x] = 1;
        }
        for ($i=1; $i<=4; $i++) {
            $wavg[$x][$i] = '1';
            if (!isset($wdsum_arr[$x][$i])) {
                $wdsum_arr[$x][$i] = 0;
            }
            $wavg[$x][$i] = $wdsum_arr[$x][$i] / $wdcount_arr[$x];
        }
        $chart[$BAW_MES[84+$x]][] = @array('data'=> $wavg[$x][4], 'class' => $class, 'format' => 'layout_visits');
        $chart[$BAW_MES[84+$x]][] = @array('data'=> $wavg[$x][1], 'class' => $class, 'format' => 'layout_pages');
        $chart[$BAW_MES[84+$x]][] = @array('data'=> $wavg[$x][2], 'class' => $class, 'format' => 'layout_hits');
        $chart[$BAW_MES[84+$x]][] = @array('data'=> $wavg[$x][3], 'class' => $class, 'format' => 'layout_bytes');
        $newval[84+$x] = array($BAW_MES[84+$x], $wavg[$x][4],$wavg[$x][1],$wavg[$x][2],$wavg[$x][3]);
        if ($class !== '') {
            $data_format[84+$x] = $class;
        }
    }
    // $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['chart']) {
        $out .= baw_render_htmlchart($chart, $set['avg'], false);
    }
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], false, $data_format);
    }
    return $out;
}

function baw_display_hours($set) {
    // we have to calculate the average of each hour depending on how many days have
    // data at all in this month
    // half days will create slightly inaccuarate data.
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $chart = array();
    $format = array(
        0 => array ('title'=> $BAW_MES[20], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['TIME']) && isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['DAY'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['TIME'];
        $days = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['DAY'];
        $count_days = count($days);
        foreach ($val as $hour => $data) {
            $ihour = $hour + 1;
            if ($ihour >= 13) {
                $ihour = ($hour - 11);
            }
            $icon = baw_create_image($BAW_CONF['icons_url'] . "/clock/hr$ihour.png" , array("alt"=>$hour, "title"=>$hour));
            $data[1] = $data[1] / $count_days;
            $data[2] = $data[2] / $count_days;
            $data[3] = $data[3] / $count_days;
            $chart[$hour."<br>".$icon][] = array('data'=> $data[1], 'format' => 'layout_pages');
            $chart[$hour."<br>".$icon][] = array('data'=> $data[2], 'format' => 'layout_hits');
            $chart[$hour."<br>".$icon][] = array('data'=> $data[3], 'format' => 'layout_bytes');
            $lhour  = sprintf('%02d',$hour);
            $newval[$hour] = array(
                "$lhour:00 - $lhour:59",
                $data[1],
                $data[2],
                $data[3]
            );
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['chart']) {
        $out .= baw_render_htmlchart($chart, $set['avg'], false);
    }
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total']);
    }
    return $out;
}

function baw_display_domains($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $chart = array();
    $format = array(
        0 => array ('title'=> $BAW_MES[25] , 'format' => 'layout_text','colspan' => 3),
        1 => array ('format' => 'layout_text'),
        2 => array ('format' => 'layout_text'),
        3 => array ('percent' => true, 'title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        4 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        5 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);')
    );
    // $format_jp = array($BAW_MES[56], $BAW_MES[57], $BAW_MES[75]);
    $newval = array();
    // $jpval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['DOMAIN'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['DOMAIN'];
        foreach ($val as $domain => $data) {
            $icon = baw_create_image($BAW_CONF['icons_url'] . "/flags/$domain.png" , array("alt" => $domain, "title" => $domain));
            $chart[$domain."<br>".$icon][] = array('data'=> $data[1], 'format' => 'layout_pages');
            $chart[$domain."<br>".$icon][] = array('data'=> $data[2], 'format' => 'layout_hits');
            $chart[$domain."<br>".$icon][] = array('data'=> $data[3], 'format' => 'layout_bytes');
            $newval[$domain] = array(
                $icon,
                @$BAW_LIB['domains'][$domain],
                $domain,
                $data[1],
                $data[2],
                $data[3]
            );
            /* $jpval[$domain] = array(
                $data[1],
                $data[2],
                $data[3]
            );*/
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $out = '';
    // create a map of the world image
    if (isset($set['map']) && ($set['map'])) {
        $doms = '';
        $show = 1;
        $cnt = 0;
        $lim = 20;
        $lst = 0;
        $ushack = 0;
        foreach ($newval as $domain => $data) {
            if ($cnt < $lim) {
                if ((strncmp($domain,'us',2)==0) ||
                    (strncmp($domain,'mil',3)==0) ||
                    (strncmp($domain,'edu',3)==0) ||
                    (strncmp($domain,'gov',3)==0)) {
                    $ushack += $data[2+$show];
                } else {
                    $doms .= $domain . $data[2+$show] . ';';
                    $lst = $data[2+$show];
                }
            } else {
                break;
            }
            $cnt += 1;
        }
        // add ushack if it has more than the last entry on the list to be turned into a map image...
        if ($ushack>0) {
            $doms .= 'us' . $ushack . ';';
        }
        if ($cnt>0) {
            $out .= '<div class="baw-map"><img src="/admin/bawstats_mapimage/'
                . $show . '/' . $doms
                . '" width="575" height="286"  alt="map of domains" /></div>';
        }
    }
    if ($set['chart']) {
        $out .= baw_render_htmlchart($chart, $set['avg'], $set['top_x']);
    }
    /* if ($set['piechart'] && $BAW_CONF['use_jpgraph']) {
       $out .= baw_render_jpgraph($set['name'], $jpval, $format_jp, 'bar', $set['avg'], $set['top_x'], $set['sort']);
    }*/
    if ($set['table']) {
        $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x']);
    }
    return $out;
}

function baw_display_visitors($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $format = array( // first line
        0 => array ('title'=> $BAW_MES[81], 'format' => 'layout_text'),
        // 1 => array ('data'=> $BAW_MES[114], 'class' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        4 => array ('title'=> $BAW_MES[9], 'format' => 'layout_date'),
    );

    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['VISITOR'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['VISITOR'];
        foreach ($val as $dns => $data) {
            // $infolink = baw_create_link("?", "javascript:neww('$dns','{$dns}XXX')");
            // $line[] = array ('data'=> $infolink, 'class' => "aligncenter", 'format' => 'layout_index');
            if (!$set['hidebots'] or $data[1] !== $data[2]) {
                $newval[$dns] = array($data[0],$data[1],$data[2],$data[3],$data[4]);
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x']);
    }
    return $out;
}

function baw_display_logins($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $format = array(
        0 => array ('title'=> $BAW_MES[94], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        4 => array ('title'=> $BAW_MES[9], 'format' => 'layout_date'),
    );

    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['LOGIN'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['LOGIN'];
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_robots($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[53], 'format' => 'layout_text'),
        1 => array ('percent' => false, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        2 => array ('title'=> $BAW_MES[57] . " (robots.txt)", 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        4 => array ('title'=> $BAW_MES[9], 'format' => 'layout_date'),
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['ROBOT'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['ROBOT'];
        foreach ($val as $robot => $data) {
            if (isset($BAW_LIB['robots'][$robot])) {
                $robot = $BAW_LIB['robots'][$robot];
                $robot = str_replace(' target="_blank"', '', $robot);
            }
            $newval[$robot] = array(
                $robot,
                $data[1]-$data[4],
                $data[4],
                $data[2],
                $data[3],
            );
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x']);
    }
    return $out;
}

function baw_display_worms($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[163], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[167], 'format' => 'layout_text'),
        2 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        4 => array ('title'=> $BAW_MES[9], 'format' => 'layout_date'),
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['WORMS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['WORMS'];
        foreach ($val as $worm => $data) {
            $newval[$worm] = array(
                $BAW_LIB['worms']['names'][$worm],
                $BAW_LIB['worms']['targets'][$worm],
                $data[1],
                $data[2],
                $data[3]
            );
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x']);
    }
    return $out;
}

function baw_display_sessions($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[117], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[10], 'format' => 'layout_visits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );

    $newval = array();
    $sum = 0; // sum for "unknown"
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SESSION'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SESSION'];
        foreach ($BAW_LIB['sessions'] as $timespan) {
            $newval[$timespan] = array($timespan, 0);
            if (isset($val[$timespan][1])) {
                $newval[$timespan][1] = $val[$timespan][1];
                $sum += $val[$timespan][1];
            }
        }
        $unknown = $BAW_CURR['thismonth']['hits'] - $sum;
        $newval['Unknown'] = array('Unknown', $unknown);
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    // $newval = baw_array_sorting($newval, 1, SORT_DESC);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], false);
    }
    return $out;
}

function baw_display_filetype($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[73], 'format' => 'layout_text', 'colspan' => 3),
        1 => array ('format' => 'layout_text'),
        2 => array ('format' => 'layout_text'),
        3 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        4 => array ('percent' => true, 'title'=> $BAW_MES[75], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        5 => array ('title'=> $BAW_MES[100], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        6 => array ('title'=> $BAW_MES[101], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        7 => array ('title'=> $BAW_MES[99], 'format' => 'layout_bytes', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        8 => array ('title'=> "Ratio", 'format' => 'layout_percent')
    );
    // $format_pie = array($BAW_MES[57], $BAW_MES[75], $BAW_MES[99]);

    $newval = array();
    // $pieval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['FILETYPES'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['FILETYPES'];
        // Files type - Hits - Bandwidth - Bandwidth without compression - Bandwidth after compression
        $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
        foreach ($val as $type => $data) {
            $icon = '';
            if (isset($BAW_LIB['files']['icons'][$type])) {
                $iconname = $BAW_LIB['files']['icons'][$type];
                $icon = baw_create_image($BAW_CONF['icons_url'] . "/mime/$iconname.png" , array("alt" => $iconname, "title" => $iconname));
            }
            $newval[$type][0] = $icon;
            $newval[$type][1] = $type;
            if ($type == 'Unknown') {
                $newval[$type][1] = "?";
                $newval[$type][2] = $type;
            } else {
                $desc = @$BAW_LIB['files']['types'][$BAW_LIB['files']['family'][$type]];
                $newval[$type][2] = $desc;
            }
            $newval[$type][3] = $data[1];
            $newval[$type][4] = $data[2];
            $newval[$type][5] = $data[3];
            $newval[$type][6] = $data[4];
            $newval[$type][7] = $data[3] - $data[4];
            @$ratio = ($data[3] - $data[4]) / ($data[3] / 100);
            $newval[$type][8] = $ratio;
            $chart[$type][] = array('data' => $data[1], 'class' => '', 'format' => 'layout_hits');
            $chart[$type][] = array('data' => $data[2], 'class' => '', 'format' => 'layout_bytes');
            // $chart[$type][] = array('data' => $ratio, 'class' => '', 'format' => 'layout_percent');
            // $chart[$type][] = array('data' => $data[4], 'class' => '', 'format' => 'layout_bytes');
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }

    // $chart = baw_array_sorting($chart, $set['sort'], $set['sort_dir']);
    // $pieval = baw_array_sorting($pieval, 1, $set['sort_dir']);
    $out = '';
    if ($set['chart']) {
        $out .= baw_render_htmlchart($chart, $set['avg'], $set['top_x']);
    }
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_urls($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF;
    $format = array(
        0 => array ('title'=> $BAW_MES[19], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[29], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('title'=> $BAW_MES[106], 'format' => 'layout_bytes'),
        3 => array ('title'=> $BAW_MES[104], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(5);', 'onmouseout' => 'HideTip(5);'),
        4 => array ('title'=> $BAW_MES[116], 'format' => 'layout_hits')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SIDER'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SIDER'];
        foreach ($val as $url => $data) {
            $link = baw_create_link($url, "http://{$BAW_CURR['site_name']}$url", array('title'=>htmlspecialchars($url)));
            $val[$url][0] = $link;
            $val[$url][2] = $data[2]/$data[1]; // average size per page instead of sum
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_os($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[59], 'format' => 'layout_text', 'colspan' => 2, 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('format' => 'layout_text'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['OS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['OS'];
        $newval = $BAW_LIB['os']['families']; // create an array where the main are already
        if ($BAW_CONF['module'] == 'drupal') {
            $url = "/admin/bawstats/details/unknownos/{$BAW_CURR['month']}/{$BAW_CURR['year']}";
        } else {
            $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&month={$BAW_CURR['month']}&year={$BAW_CURR['year']}&action=get_fulltable&what=unknownos";
        }
        foreach ($val as $os => $data) {
            $isnew = true; // this os has not been added to newvar yet (not families)
            foreach ($BAW_LIB['os']['codes'] as $code) {
                if (stristr($os, $code) !== false) {
                    $newval[$code][2] += $data[1]; // found it, add stats
                    $iconid = $code;
                    $isnew = false; // we have the stats now
                }
            }
            if ($isnew) { // this is an additional, non-family os
                $iconid = $os;
                $os_link = $BAW_LIB['os']['list'][$os];
                //target blank is not html strict
                $os_link = baw_sanitize_link($os_link);
                $newval[$os] = array('', $os_link, $data[1]);
            }
            if ($os == 'Unknown') {
                $newval[$os][1] = baw_create_link('Unknown', $url);
            }
            $icon = baw_create_image($BAW_CONF['icons_url'] . "/os/" . str_replace('/', '', strtolower($iconid)) . '.png');
            $newval[$iconid][0] = $icon;
        }
        foreach ($newval as $data) {
            if ($data[2] == 0) {
                unset ($newval[$data[0]]);
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_osversions($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[59], 'format' => 'layout_text', 'colspan' => 2, 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('format' => 'layout_text'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['OS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['OS'];
        if ($BAW_CONF['module'] == 'drupal') {
            $url = "/admin/bawstats/details/unknownos/{$BAW_CURR['month']}/{$BAW_CURR['year']}";
        } else {
            $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&month={$BAW_CURR['month']}&year={$BAW_CURR['year']}&action=get_fulltable&what=unknownos";
        }
        $newval = array();
        foreach ($val as $os => $data) {
            $iconid = $os;
            $icon = baw_create_image($BAW_CONF['icons_url'] . "/os/" . str_replace('/', '', strtolower($iconid)) . '.png');
            $os_link = $BAW_LIB['os']['list'][$os];
            $os_link = baw_sanitize_link($os_link);
            $newval[$os] = array($icon, $os_link, $data[1]);
            if ($os == 'Unknown') {
                $newval[$os][1] = baw_create_link('Unknown', $url);
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, 2, $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_unknownos($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[46], 'format' => 'layout_text'),
        1 => array ('percent' => false, 'title'=> $BAW_MES[9], 'format' => 'layout_date', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['UNKNOWNREFERER'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['UNKNOWNREFERER'];
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_browsers($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[21], 'format' => 'layout_text', 'colspan' => 2, 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('format' => 'layout_text'),
        2 => array ('title'=> $BAW_MES[111], 'format' => 'layout_text'),
        3 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits')
    );
    $search = array(
        '\\s',
        '\\-'
    );
    $replace  = array(
        "_",
        "-"
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['BROWSER'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['BROWSER'];
        $lib = $BAW_LIB['browser']['names'];
        if ($BAW_CONF['module'] == 'drupal') {
            $url = "/admin/bawstats/details/unknownbrowser/{$BAW_CURR['month']}/{$BAW_CURR['year']}";
        } else {
            $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&month={$BAW_CURR['month']}&year={$BAW_CURR['year']}&action=get_fulltable&what=unknownbrowser";
        }
        // iterate all browsers in the library
        foreach ($lib as $browser => $description) {
            // get the icon
            $icon = '';
            if (isset($BAW_LIB['browser']['icons'][$browser])) {
                $icon = $BAW_LIB['browser']['icons'][$browser];
                $icon = str_replace($search, $replace, $icon);
                $icon = baw_create_image($BAW_CONF['icons_url'] . "/browser/$icon.png");
            }
            // grabber ?
            $grabber = $BAW_MES[113];
            if (isset($BAW_LIB['browser']['grabbers'][$browser])) {
                $grabber = $BAW_MES[112];
            }

            // create table line for this browser since we dont need versions
            $description = str_replace(' target="_blank"', '', $description);
            $newval[$browser] = array($icon, $description, $grabber, 0);
            if ($browser == 'Unknown') {
                $newval[$browser][1] = baw_create_link('Unknown', $url);
                $newval[$browser][2] = '?';
            }
            // summ all occurences of this browser
            foreach ($val as $browser_ver => $hits) {
                // only add if hits and if the browser matches
                if (($hits > 0) and stristr($browser_ver, $browser) !== false) {
                    @$newval[$browser][3] += $hits[1];
                }
            }
            // kill zero-value browsers
            if ($newval[$browser][3] == 0) {
                unset($newval[$browser]);
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_browserversions($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[21] . " " . $BAW_MES[58], 'format' => 'layout_text', 'colspan' => 3, 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('format' => 'layout_text'),
        2 => array ('format' => 'layout_text'),
        3 => array ('title'=> $BAW_MES[111], 'format' => 'layout_text'),
        4 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits')
    );
    $search = array(
        '\\s',
        '\\-'
    );
    $replace  = array(
        "_",
        "-"
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['BROWSER'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['BROWSER'];
        if ($BAW_CONF['module'] == 'drupal') {
            $url = "/admin/bawstats/details/unknownbrowser/{$BAW_CURR['month']}/{$BAW_CURR['year']}";
        } else {
            $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&month={$BAW_CURR['month']}&year={$BAW_CURR['year']}&action=get_fulltable&what=unknownbrowser";
        }
        $lib = $BAW_LIB['browser']['names'];
        // iterate all browsers in the library
        foreach ($val as $browser_ver => $hits) {
            // separate text from numbers/points
            preg_match('/([a-zA-Z\W]+)((.?([0-9]))*)/', $browser_ver, $matches);
            $browser = $matches[1];
            $version = $matches[2];
            $grabber = $BAW_MES[113];
            $icon = '';
            if (isset($BAW_LIB['browser']['names'][$browser])) {
                $description = $lib[$browser];
                if (isset($BAW_LIB['browser']['icons'][$browser])) {
                    $icon = $BAW_LIB['browser']['icons'][$browser];
                    $icon = str_replace($search, $replace, $icon);
                    $description = baw_sanitize_link($description);
                    $icon = baw_create_image($BAW_CONF['icons_url'] . "/browser/$icon.png", array('title' => $icon));
                }
            } else {
                $description = $browser_ver;
                $grabber = '?';
            }
            // grabber ?
            if (isset($BAW_LIB['browser']['grabbers'][$browser])) {
                $grabber = $BAW_MES[112];
            }
            @$newval[$browser_ver] = array($icon, $description , $version, $grabber, $hits[1]);
            if ($browser == 'Unknown') {
                $newval[$browser][1] = baw_create_link('Unknown', $url);
                $newval[$browser][2] = '?';
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_unknownbrowser($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[50], 'format' => 'layout_text'),
        1 => array ('percent' => false, 'title'=> $BAW_MES[9], 'format' => 'layout_date', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['UNKNOWNREFERERBROWSER'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['UNKNOWNREFERERBROWSER'];
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_screensizes($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[135], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SCREENSIZE'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SCREENSIZE'];
        /* foreach ($val as $size => $data) {
            $size_arr = explode("x", $size);
            $val[$size][2] = $size_arr[0] * $size_arr[1];
        } */
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_se_referers($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[126], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SEREFERRALS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SEREFERRALS'];
        foreach ($val as $id => $data) {
            $sename = @$BAW_LIB['searchengines']['names'][$id];
            $sename = str_replace(' target="_blank"', '', $sename);
            $val[$id][0] = $sename;
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_referers($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[127], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'];
        foreach ($val as $id => $data) {
            if ($data[1] > 0) {
                $link = baw_create_link($id, $id);
                $newval[$id] = array($link,$data[1],$data[2]);
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_referer_domains($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[127] . " by Domains", 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'];
        foreach ($val as $id => $data) {
            if ($data[1] > 0) {
                $link = baw_create_link($id, $id);
                $tld = @parse_url($id);
                $tld = $tld['scheme'] ."://". $tld['host'];
                $tld = str_replace("http://www.", "http://", $tld);
                if (!isset($newval[$tld])) {
                    $link = baw_create_link($tld, $tld);
                    $newval[$tld] = array($link, $data[1],$data[2]);
                } else {
                    $newval[$tld][1] += $data[1];
                    $newval[$tld][2] += $data[2];
                }
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}


function baw_display_hotlinks($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[127], 'format' => 'layout_text'),
        //1 => array ('title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'];
        foreach ($val as $id => $data) {
            if ($data[1] == 0) {
                $link = baw_create_link($id, $id);
                $newval[$id] = array($link, $data[2]); //$data[1],
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_hotlink_domains($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[127] . " Hotlinks by Domains", 'format' => 'layout_text'),
        // 1 => array ('title'=> $BAW_MES[56], 'format' => 'layout_pages', 'onmouseover' => 'ShowTip(3);', 'onmouseout' => 'HideTip(3);'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['PAGEREFS'];
        foreach ($val as $id => $data) {
            if ($data[1] == 0) {
                $link = baw_create_link($id, $id);
                $tld = @parse_url($id);
                $tld = $tld['scheme'] ."://". $tld['host'];
                if (!isset($newval[$tld])) {
                    $link = baw_create_link($tld, $tld);
                    $newval[$tld] = array($link, $data[2]); //$data[1],
                } else {
                    // $newval[$tld][1] += $data[1];
                    $newval[$tld][1] += $data[2];
                }
            }
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}


function baw_display_searchphrases($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[103], 'format' => 'layout_text'),
        1 => array ('percent'=> true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SEARCHWORDS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SEARCHWORDS'];
        foreach ($val as $id => $data) {
            $val[$id][0] = str_replace('+', ' ', $data[0]);
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_searchwords($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[13], 'format' => 'layout_text'),
        1 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);')
    );
    $val = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['KEYWORDS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['KEYWORDS'];
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $val = baw_array_sorting($val, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $val, $format, $set['avg'], $set['total'], $set['top_x'], false);
    }
    return $out;
}

function baw_display_misc($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[139], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        2 => array ('title'=> $BAW_MES[15], 'format' => 'layout_percent')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['MISC'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['MISC'];
        foreach ($BAW_LIB['misc'] as $type => $msg) {
            @$percent = $val[$type][2] / ($val['TotalMisc'][2]  / 100);
            $newval[$type] = array($BAW_MES[$msg], @$val[$type][2], $percent);
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }

    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format);
    }
    return $out;
}

function baw_display_errors($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[32], 'format' => 'layout_text', 'colspan'=> 2),
        1 => array ('format' => 'layout_text'),
        2 => array ('percent' => true, 'title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        3 => array ('title'=> $BAW_MES[106], 'format' => 'layout_bytes')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['ERRORS'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['ERRORS'];
        foreach ($val as $type => $data) {
            if ($data[0] == '404') {
                if ($BAW_CONF['module'] == 'drupal') {
                    $data[0] = baw_create_link('404', "/admin/bawstats/details/errors404/{$BAW_CURR['month']}/{$BAW_CURR['year']}");
                } else {
                    $data[0] = baw_create_link('404', "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&month={$BAW_CURR['month']}&year={$BAW_CURR['year']}&action=get_fulltable&what=errors404");
                }
            }
            $newval[$type] = array(
                $data[0], $BAW_LIB['http_status'][$type], $data[1], $data[2]
            );
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format);
    }
    return $out;
}

function baw_display_errors404($set) {
    global $BAW_MES, $BAW_CURR, $BAW_D, $BAW_CONF, $BAW_LIB;
    $format = array(
        0 => array ('title'=> $BAW_MES[49], 'format' => 'layout_text'),
        1 => array ('title'=> $BAW_MES[57], 'format' => 'layout_hits', 'onmouseover' => 'ShowTip(4);', 'onmouseout' => 'HideTip(4);'),
        2 => array ('title'=> $BAW_MES[127], 'format' => 'layout_text')
    );
    $newval = array();
    if (isset($BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SIDER_404'])) {
        $val = $BAW_D[$BAW_CURR['site_name']][$BAW_CURR['monthyear']]['SIDER_404'];
        foreach ($val as $type => $data) {
            $newval[$type] = array(
                baw_create_link($data[0], "http://{$BAW_CURR['site_name']}{$data[0]}"),
                $data[1],
                baw_create_link($data[2],$data[2])
            );
        }
    } else if ($BAW_CONF['hideempty']){
        return '';
    }
    $newval = baw_array_sorting($newval, $set['sort'], $set['sort_dir']);
    $out = '';
    if ($set['table']) {
        $out .= baw_render_table($set['name'], $newval, $format, false, $set['total'], $set['top_x']);
    }
    return $out;
}
/*

  From0 6240 13402
From1 3 11 // unknown
From2 5471 8003 // search engine
From3 1956 3723 // external page
From4 10544 208546 // bookmarks/direct
From5 0 0 // newsgroups

*/
?>
