<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'display_helpers.php') !== false) {
    die ('This file can not be used on its own!');
}

// general display control
// this function uses echo instead of return to output also in case of error
function baw_display_index($settings = array()) {
    global $BAW_CONF, $BAW_CONF_DIS, $BAW_CONF_DIS_DEF, $BAW_D, $BAW_MES, $BAW_CURR, $BAW_LIB;
    baw_read_data();
    echo baw_site_header($BAW_CURR['site_name']);
    $outtime = baw_timereport("Data processing time", true);

    // sort the charts according to order in config
    $BAW_CONF_DIS = baw_array_sorting($BAW_CONF_DIS, 'order', SORT_ASC);

    // ---- MENU BOX -----------------------------------------------------------
    $menubox = "\n\n<!-- MENU START ++++++++++++++++++++++++++++++++++++++ -->\n"
        . "<div class=\"menubox\">\n"
        . "<h2>{$BAW_MES[7]}: {$BAW_CURR['site_name']}</h2>\n";
    $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&amp;month={$BAW_CURR['month']}&amp;year={$BAW_CURR['year']}";
    $menubox .= "    <ul class=\"menu\" >\n"
        . "<li>\n            <a href=\"#top\">{$BAW_MES[77]}</a>\n            </li>\n";
    if ($BAW_CURR['site_name'] == 'all_months' or $BAW_CURR['site_name'] == 'all_days') {
        foreach ($BAW_CURR['sites'] as $site) {
            $menubox .= "        <li>\n            <a href=\"$url#site_$site\">$site</a> \n";
            $menubox .= "        </li>\n";
        }
    } else {
        if ($BAW_CONF['layout_type'] == 'compact') {
            foreach ($BAW_LIB['item_groups'] as $group => $group_details) {
                $name = $group_details['title'];
                $menubox .= "        <li>\n            <a href=\"$url#h2_$group\">$name</a> \n";
                $menubox .= "        </li>\n";
            }
        } else {
            $count_sections = count($BAW_CONF_DIS);
            foreach ($BAW_CONF_DIS as $section => $sect_data) {
                if ($sect_data['show'] == true) {
                    $name = $BAW_CONF_DIS_DEF[$section]['name'];
                    $menubox .= "        <li>\n            <a href=\"$url#h2_$section\">$name</a> \n";
                    $menubox .= baw_display_full_list_link ($section, '', true, true);
                    $menubox .= "        </li>\n";
                }
            }
        }
    }
    //if (is_writable('./config.php')) {
        $config_link = "    <a href=\"{$BAW_CONF['site_url']}/index.php?action=config_editor\">Configuration Editor</a>";
    //} else {
    //    $config_link = "    Configuration file not writable!";
    //}
    $menubox .= "    </ul>\n";
    $menubox .= $config_link . "<br>" . baw_display_version();
    $menubox .= "\n</div>\n<!-- MENU END - TOP MENU START ++++++++++++++++++++++++++++++++++++++ -->\n";

    // ---------- CONTENT BOX --------------------------------------------------
    // create the main content
    $content = "<div class=\"contentbox\">\n" . $outtime;
    // this should be removed once we move to beta.
    $text = "Thank you for trying BetterAWstats BETA.<br>Please report problems to the <a href=\"http://tokyoahead.com/main/forum/index.php?forum=11\">forum</a> or "
        . "tell us if this works by taking a <a href=\"{$BAW_CONF['site_url']}/index.php?action=poll\">1-second poll</a>.";
    $content .= "\n<div class=\"errorbox\">$text</div>\n";
    // top form for date/site selection
    $content .= "<form action=\"{$_SERVER['SCRIPT_NAME']}\" method=\"get\">\n"
        . "<div class=\"menu\">\n{$BAW_MES[133]}: \n"
        . baw_sites_dropdown() . baw_date_dropdown()
        . "<input type=\"submit\" value=\"{$BAW_MES[115]}\">\n"
        . "</div>\n"
        . "</form>\n"
        . baw_timereport("Top Menu Display time")
        . baw_display_tooltips();
    // show each

    if ($BAW_CURR['site_name'] == 'all_months') {
        $settings['section'] = "months";
        $section = $settings['section'];
        $function = "baw_display_$section";
        $temp_conf = $BAW_CONF_DIS[$section];
        $temp_conf['top_x'] = false;
        $temp_conf['chart'] = true;
        $temp_conf['table'] = false;
        $temp_conf['name'] = $BAW_CONF_DIS_DEF[$section]['name'];
        $content .= $function($temp_conf);
    } else if ($BAW_CURR['site_name'] == 'all_days') {
        $settings['section'] = "days";
        $section = $settings['section'];
        $function = "baw_display_$section";
        $temp_conf = $BAW_CONF_DIS[$section];
        $temp_conf['top_x'] = false;
        $temp_conf['chart'] = true;
        $temp_conf['table'] = false;
        $temp_conf['name'] = $BAW_CONF_DIS_DEF[$section]['name'];
        $content .= $function($temp_conf);
    } else if (isset($settings['section'])) {
        $section = $settings['section'];
        $function = "baw_display_$section";
        $temp_conf = $BAW_CONF_DIS[$section];
        $temp_conf['top_x'] = false;
        $temp_conf['chart'] = false;
        $temp_conf['table'] = true;
        $temp_conf['name'] = $BAW_CONF_DIS_DEF[$section]['name'];
        $content .= $function($temp_conf);
    } else {
        $content .= "\n<!-- CONTENT START ++++++++++++++++++++++++++++++++++++++ -->\n";
        if ($BAW_CONF['layout_type'] == 'compact') {
            foreach ($BAW_LIB['item_groups'] as $group => $group_details) {
                $group_items = $group_details['members'];
                $menubuttons = '';
                $stats_section = '';
                $item_id = 0;
                $count_members = count($group_details['members']);
                $content .= "\n<!-- GROUP $group START ++++++++++++++++++++++++++++++++++++++ -->\n";
                $content .= baw_section_header($group, $group_details['title'], false, 'group_title');
                foreach ($group_details['members'] as $item) {
                    $stats_section .= "\n<!-- ITEM {$BAW_CONF_DIS_DEF[$item]['name']} START ++++++++++++++++++++++++++++++++++++++ -->\n";
                    $button_title = $BAW_CONF_DIS_DEF[$item]['name'];
                    if ($item_id == 0) {
                        $button_class = "top_menu_button_active";
                    } else {
                        $button_class = "top_menu_button";
                    }
                    $menubuttons .= "<div class=\"$button_class\" id=\"button_{$group}_$item_id\" onClick=\"toggleBox($item_id, '$group', $count_members);\">$button_title</div>\n";
                    $sect_data = $BAW_CONF_DIS[$item];
                    $sect_data['name'] = $item;
                    if ($item == 'weekdays' && !isset($BAW_CURR['wdays']['count'])) {
                        $setarr = array('collapse' => false, 'chart' => false,'table' => false);
                        baw_display_weekdays($setarr);
                    }
                    $class = 'aws_data';
                    if ($sect_data['show'] == true) {
                        $function = "baw_display_$item";
                        $title = $BAW_CONF_DIS_DEF[$item]['name'];
                        $collapse = $sect_data['collapse'];

                        if ($BAW_CONF['layout_type'] == 'compact') {
                            $name = "{$group}_$item_id";
                            $collapse = false;
                            if ($item_id == 0) {
                                $class = 'aws_data_show';
                            } else {
                                $class = 'aws_data_hide';
                            }
                        } else {
                            $name = $sect_data['name'];
                        }
                        $stats_html = $function($sect_data);
                        if (strlen($stats_html)> 1) {
                            $stats_section .= baw_section_header($name, $title, $collapse, $class)
                                . $stats_html
                                . baw_section_footer();
                        }
                    }
                    $stats_section .= "\n<!-- ITEM $name END ++++++++++++++++++++++++++++++++++++++ -->\n";
                    $item_id++;
                }
                $content .= $menubuttons . "<div style=\"clear:both;\"></div>\n$stats_section\n";
                $content .= baw_section_footer();
                $content .= "\n<!-- GROUP $group END ++++++++++++++++++++++++++++++++++++++ -->\n";
            }
        } else {
            foreach ($BAW_CONF_DIS as $section => $sect_data) {
                $stats_html = '';
                $content .= "\n<!-- ITEM $section START ++++++++++++++++++++++++++++++++++++++ -->\n";
                $title = $BAW_CONF_DIS_DEF[$section]['name'];
                $collapse = $sect_data['collapse'];
                $class = 'aws_data';
                $name = $section;
                $sect_data['name'] = $section;
                if ($sect_data['show'] == true) {
                    $function = "baw_display_$section";
                    $stats_html = $function($sect_data);
                    if (strlen($stats_html)> 1) {
                         $content .= baw_section_header($name, $title, $collapse, $class)
                             . $stats_html
                             . baw_section_footer();
                    }
                }
                $content .= "\n<!-- ITEM $section END ++++++++++++++++++++++++++++++++++++++ -->\n";
            }
        }
        $content .= "\n<!-- CONTENT END ++++++++++++++++++++++++++++++++++++++ -->\n";
    }
    $content .= baw_timereport("Page created in", true)
        . "</div>"
        . "<div style=\"clear:both;\"></div>";
    $out = $menubox . $content
        . baw_site_footer();
    return $out;
}

function baw_display_version() {
    global $BAW_CONF_DEF;
    $out = "\n<div class=\"version\">created by "
        . "<a href=\"http://tokyoahead.com/main/staticpages/index.php/betterawstats\">"
        . "BetterAWstats</a> {$BAW_CONF_DEF['Advanced Settings']['version']['default']}"
        . "</div>\n";
    return $out;
}

function baw_display_full_list_link ($section, $text, $useicon = true) {
    global $BAW_CONF_DIS, $BAW_CONF, $BAW_MES, $BAW_CURR;
    $out = '';
    $icon = '';

    if ($BAW_CONF['module'] == 'drupal') {
        $url = "/admin/bawstats/details/$section/{$BAW_CURR['month']}/{$BAW_CURR['year']}";
        $out .= "<a title=\"{$BAW_MES[80]}\" href=\"$url\">$text</a>";
    } else {
        if (isset($BAW_CONF_DIS[$section]['top_x'])) {
            if ($useicon == true) {
                $icon = baw_create_image($BAW_CONF['icons_url'] ."/other/page.png", array('title'=> $BAW_MES[80])) . " ";
            } else {
                $icon = '';
            }
            $url = "{$BAW_CONF['site_url']}/index.php?site={$BAW_CURR['site_name']}&amp;month={$BAW_CURR['month']}&amp;year={$BAW_CURR['year']}";
            $urlsub = "$url&amp;action=get_fulltable&amp;what=$section";
            $out .= "<a title=\"{$BAW_MES[80]}\" href=\"$urlsub\">$icon$text</a>";
        }
    }
    return $out;
}

function baw_action_get_fulltable() {
    $settings = array();
    $out = '';
    if (isset($_GET['what'])) {
        $what = $_GET['what'];
        $settings['section'] = $what;
    } else {
        $out = baw_display_index();
    }
    if (isset($_GET['sort'])) {
        $sort = $_GET['sort'];
        $settings['sort'] = $sort;
    };
    $out .= baw_display_index($settings);
    return $out;
}

function baw_action_save_config() {
    global $BAW_CONF, $BAW_CONF_DEF, $BAW_CONF_DIS_DEF, $BAW_CONF_DIS;
    if (!$BAW_CONF['online_config']) {
        return baw_raise_error('configdisabled');
    }
    $filename = './config.php';
    if (is_writable($filename)) {
        if (!$handle = fopen($filename, 'w+')) {
            return baw_raise_error('configread');
        }
        // prepare config for writing
        $str = "<?php\r\n";
        $intro = "// ATTENTION:\r\n// BetterAWstats has an online config editor that you can use "
            ."instead of editing this file here. The link is on the bottom "
            ."of the menu! To use it, set \$BAW_CONF['online_config'] = true;";
        $str .= wordwrap($intro, 75, "\r\n// ");
        foreach ($BAW_CONF_DEF as $sect => $sectdata) {
            $sect = strtoupper($sect);
            $str .= "\r\n\r\n//*********************************************************/\r\n"
                 . "//*          $sect\r\n"
                 . "//*********************************************************/\r\n\r\n";
            foreach ($sectdata as $setting => $misc) {
                if ($misc['type'] !== 'fixed') {
                    $val = $_POST[$setting];
                    if ($val == 'true' or $val == 'false') {
                        $val = "$val";
                    } else if ($val == "'"){
                        $val = '"\'"';
                    } else {
                        $val = "'$val'";
                    }
                    $default = $misc['default'];
                    if (is_bool($default)) {
                        if ($default) {
                            $default = 'true';
                        } else {
                            $default = 'false';
                        }
                    } else {
                        $default = "'$default'";
                    }
                    $allowed_values = '';
                    if ($misc['type'] == 'dropdown') {

                        $allowed_values = implode("', '", array_keys($misc['values']));
                        $allowed_values = wordwrap($allowed_values, 60, "\r\n//                  ");
                        $allowed_values = "// POSSIBLE VALUES: '$allowed_values'\r\n";
                    }
                    $out_help = wordwrap($misc['help'], 68, "\r\n//          ");
                    $str .= "// NAME:    {$misc['name']}\r\n"
                          . "// INFO:    {$out_help}\r\n"
                          . "// DEFAULT: $default\r\n"
                          . $allowed_values
                          . "\$BAW_CONF['$setting'] = $val;\r\n\r\n";
                }
            }
        }
        $str .= "\r\n\r\n//*********************************************************/\r\n"
             . "//*          DISPLAY\r\n"
             . "//*********************************************************/\r\n\r\n";
        foreach ($BAW_CONF_DIS_DEF as $setting => $misc) {
            $val_arr = $_POST[$setting];
            $str .= "// NAME: {$misc['name']}\r\n"
                  . "// INFO: {$misc['help']}\r\n";
            $this_conf = $BAW_CONF_DIS[$setting];
            $substr ='';
            foreach ($this_conf as $name => $oldval) {
                $val = $val_arr[$name];
                //if (is_bool($oldval) or $name == 'sort_dir') {
                    $val = "$val";
                //} else {
                //    $val = "'$val'";
                //}
                $substr .= "    '$name' => $val,\r\n";
            }
            $str .= "\$BAW_CONF_DIS['$setting'] = array(\r\n$substr);\r\n\r\n";
        }
        $str .= "\r\n?>";
        if (fwrite($handle, $str) === FALSE) {
            return baw_raise_error('configwrite');
        }

        $out = "The configuration has been saved. Continue to the <a href=\"{$BAW_CONF['site_url']}/\">"
            . "Statistics</a> or go back to the <a href=\"{$BAW_CONF['site_url']}/index.php?action=config_editor\">"
            . "Config editor</a>.";
        $out = baw_site_header() . "<div class=\"errorbox\"><h1>BetterAWstats Saved</h1>$out</div></body></html>";
        fclose($handle);
    } else {
        $out = baw_site_header() . baw_raise_error('configwrite');
    }
    return $out;
}


function baw_action_config_editor() {
    global $BAW_CONF, $BAW_CONF_DEF, $BAW_CONF_DIS_DEF, $BAW_CONF_DIS;
    if (!$BAW_CONF['online_config']) {
        return baw_raise_error('configdisabled');
    }
    $out = "\n<form action=\"{$BAW_CONF['site_url']}/index.php\" method=\"post\">"
        ."<input type=\"hidden\" name=\"action\" value=\"save_config\">";
    $submit = "<input type=\"submit\" name=\"submit\" value=\"Save all\">";

    foreach ($BAW_CONF_DEF as $section => $set_arr) {
        $out .= "<div class=\"conf_section\"><h2>$section $submit</h2>\n";
        foreach ($set_arr as $cfgname => $cfgdata) {
            $default = $cfgdata['default'];
            if (isset($BAW_CONF[$cfgname])) {
                $val = $BAW_CONF[$cfgname];
            } else {
                $val = $BAW_CONF_DEF[$section][$cfgname]['default'];
            }
            if ($cfgdata['type'] == 'fixed') {
                $input = $val;
            } else if ($cfgdata['type'] == 'string') {
                $input = "<input type=\"text\" name=\"$cfgname\" value=\"$val\" size=\"40\">";
            } else if ($cfgdata['type'] == 'dropdown') {
                $input = baw_generic_dropdown($cfgname, $cfgdata['values'],$val);
                $default = $cfgdata['values'][$cfgdata['default']];
            }
        $out .= "<div class=\"conf_setting\"><h3>{$cfgdata['name']}</h3>\n"
            . $cfgdata['help'] . "<br>"
            . "$cfgname = $input"
            . "<br>(Default: \"<span class=\"default\">$default</span>\")"
            . "</div>\n";
        $out .= "</div>\n";
        }
    }

    $set_arr = array(
        'order' => array('Sort Order', 'string'),
        'show' => array('Show this Data?', 'bool'),
        'collapse' => array('Collapsed?', 'bool'),
        'table' => array('Show data table?', 'bool'),
        'sort' => array('Sort for which column?', 'sorting1'),
        'sort_dir' => array('Sort direction?', 'sorting2'),
        'chart' => array('Show HTML chart?', 'bool'),
        'piechart' =>  array('Show Pie Chart?', 'bool'),
        'avg' => array('Show averages?', 'bool'),
        'total' => array('Show total Sum?', 'bool'),
        'top_x' => array('Show how many entries?', 'string'),
        'hidebots' => array('Hide visitors where Hits = Pages?', 'bool'),
        'showmonths' =>  array('Show how many months?', 'string'),
    );
    $out .= "<div class=\"conf_section\"><h2>Display $submit</h2>\n";
    $BAW_CONF_DIS = baw_array_sorting($BAW_CONF_DIS, 'order', SORT_ASC);
    foreach ($BAW_CONF_DIS as $cfgname => $cfgdata) {
        $input = '';
        $default = '';
        $name = $BAW_CONF_DIS_DEF[$cfgname]['name'];
        $help = $BAW_CONF_DIS_DEF[$cfgname]['help'];
        foreach ($set_arr as $setname => $setdata) {
            if (isset($cfgdata[$setname])) {
                $val = $BAW_CONF_DIS[$cfgname][$setname];
                if ($setdata[1] == 'bool') {
                    if ($val == true) {
                        $selyes = " checked=\"checked\"";
                        $selno = "";
                    } else {
                        $selno = " checked=\"checked\"";
                        $selyes = "";
                    }
                    $input .= "<fieldset><legend>{$setdata[0]}</legend>"
                        ."Yes <input type=\"radio\" name=\"".$cfgname."[".$setname."]\" value=\"true\"$selyes> "
                        . "No <input type=\"radio\" name=\"".$cfgname."[".$setname."]\" value=\"false\"$selno> "
                        . "</fieldset>\n";
                } else if ($setdata[1] == 'string') {
                    $input .= "<fieldset><legend>{$setdata[0]}</legend>"
                        ."<input type=\"text\" name=\"".$cfgname."[".$setname."]\" value=\"$val\"size=\"5\">"
                        . "</fieldset>\n";
                } else if ($setdata[1] == 'sorting1') {
                    $sort_arr = $BAW_CONF_DIS_DEF[$cfgname]['sorting'];
                    $input .= "<fieldset><legend>{$setdata[0]}</legend>"
                        . baw_generic_dropdown($cfgname."[".$setname."]", $sort_arr,$val)
                        . "</fieldset>\n";
                } else if ($setdata[1] == 'sorting2') {
                    if ($val == 4) {
                        $selyes = " checked=\"checked\"";
                        $selno = "";
                    } else {
                        $selno = " checked=\"checked\"";
                        $selyes = "";
                    }
                    $input .= "<fieldset><legend>{$setdata[0]}</legend>"
                        ."Ascending <input type=\"radio\" name=\"".$cfgname."[".$setname."]\" value=\"SORT_ASC\"$selyes> "
                        . "Desceding <input type=\"radio\" name=\"".$cfgname."[".$setname."]\" value=\"SORT_DESC\"$selno> "
                        . "</fieldset>\n";
                }
            }
        }
        $out .= "<div class=\"conf_setting\"><h3>$name</h3>\n"
            . $help . "<br>"
            . "$input<div style=\"clear:both\"></div>"
            . $default
            . "</div>\n";
    }

    $out .= "</div>$submit\n";
    $out .= "</form>";
    return $out;
}

// this poll is only for the alpha versions or prereleases
function baw_action_poll() {
    $out = "<div class=\"errorbox\"><h1>How does BetterAWstats work?</h1>"
        .'<form action="http://tokyoahead.com/main/polls/index.php" name="Vote" method="POST">
        <input type="hidden" name="qid" value="Betterawstats">
          <input type="radio" name="aid" value="1">:-) Fine! The numbers match AWStats.<br>
        <input type="radio" name="aid" value="2">:-| The stats show, but the numbers do not match AWstats<br>
        <input type="radio" name="aid" value="3">:-( I am getting an error, no charts...<br>
        <input type="submit" value="Vote"></form></div>';
    return $out;
}


function baw_display_tooltips() {
    global $BAW_CONF;
    $path = $BAW_CONF['path_lang']."/tooltips_w/awstats-tt-{$BAW_CONF['lang']}.txt";
    if (!file_exists($path)) {
        echo baw_raise_error('languagefile', array($path));
        $file_text = array();
    } else {
        $file_text = file_get_contents($path);
    }
    return $file_text;
}

// this function corrects the links that are pulled out of the library files from
// awstats
function baw_sanitize_link($link) {
    $search = array(
        ' target="_blank"',
        ' [new window]',
        '<a href="'
    );
    $replace  = array(
        " ",
        " ",
        '<a class="ext_link" href="'
    );
    $link = str_replace($search, $replace, $link);
    return $link;
}

function baw_create_link ($content, $url, $attr=array())
{
    global $BAW_CONF;
    $attr_str = '';
    $url = htmlspecialchars($url);
    if (!isset($attr['title'])) {
        $attr['title'] = $url;
    }
    $check = strpos($url, $BAW_CONF['site_url']);
    if ($check !== 0) {
        if (isset($attr['class'])) {
            $attr['class'] .= " ext_link";
        } else {
            $attr['class'] = "ext_link";
        }
    }
    foreach ($attr as $key => $value) {
        $attr_str .= " $key=\"$value\"";
    }
    if (strlen($content) > $BAW_CONF['field_length']) {
        $content = substr($content, 0, $BAW_CONF['field_length']-3) . "...";
    }
    $content = htmlspecialchars($content);
    $out = "<a$attr_str href=\"$url\">$content</a>";

    return $out;
}

function baw_create_image($url, $attr=array()) {
    global $BAW_CONF;

    $hasalt = false;
    $attr_str = '';
    if (!isset($attr['alt'])) {
        $attr['alt'] = ' ';
    }
    foreach ($attr as $key => $value) {
        $attr_str .= " $key=\"$value\"";
    }
    if ($BAW_CONF['module'] !== 'drupal') {
        if (strpos($url, 'http://') !== 0 && strpos($url, 'https://') !== 0) {
            $url = $BAW_CONF['icons_url'] . $url;
        }
    }
    $out = "<img$attr_str src=\"$url\"" . $BAW_CONF['xhtml'] . ">";
    return $out;
}

function baw_site_header($title = '') {
    global $BAW_CONF_DEF, $BAW_CONF, $BAW_MES;
    $out = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n"
        ."<html>\n"
        ."    <head>\n"
        ."        <title>$title Better AWstats  v. {$BAW_CONF_DEF['Advanced Settings']['version']['default']}</title>\n"
        ."        <meta http-equiv=\"Content-Type\" content=\"text/html;charset={$BAW_MES['e']}\">\n"
        ."        <link rel=\"stylesheet\" type=\"text/css\" href=\"{$BAW_CONF['site_url']}/{$BAW_CONF['layout_type']}.css\">\n"
        ."    </head>\n"
        ."    <body>\n"
        ."    <script type=\"text/javascript\" src=\"{$BAW_CONF['site_url']}/scripts.js\"></script>\n"
        ."    <a name=\"top\"></a>\n";
    return $out;
}

function baw_site_footer() {
    $out ="</body></html>";
    return $out;
}

function baw_section_header($name, $title, $collapse, $class = 'aws_data') {
    $buttons = baw_show_expand_collapse($name, $collapse);
    if ($collapse) {
        $show = " style=\"display:none\"";
    } else {
        $show = "";
    }
    $out =  "<h2 class=\"$class\" id=\"h2_$name\">\n    $title\n    $buttons\n</h2>\n"
        . "<div class=\"$class\" id=\"box_$name\"$show>\n";
    return $out;
}

function baw_show_expand_collapse($name, $collapse) {
    global $BAW_CONF;
    $show1 = '';
    $show2 = '';
    if ($collapse) {
        $show2 = " style=\"display:none\"";
    } else {
        $show1 = " style=\"display:none\"";
    }
    $url = $BAW_CONF['site_url'] . "/icons/expand.gif";
    $out = "<span class=\"showhidebutton\" id=\"button_show_{$name}\" onClick=\"showElement('{$name}');\"$show1>\n    "
        . baw_create_image($url, array('title'=>'Show')) . "\n    </span>\n";
    $url = $BAW_CONF['site_url'] . "/icons/collapse.gif";
    $out .= "    <span class=\"showhidebutton\" id=\"button_hide_{$name}\" onClick=\"hideElement('{$name}');\"$show2>\n    "
        . baw_create_image($url, array('title'=>'Hide')) . "\n    </span>\n";
    return $out;
}

function baw_section_footer() {
    $out = "</div>\n";
    return $out;
}

function baw_generic_dropdown($name, $list, $selected='', $attr='') {
    $out = "<select $attr name=\"$name\">\n";
    foreach ($list as $key => $value) {
        if (is_bool($selected)) {
            if ($selected) {
                $selected = 'true';
            } else {
                $selected = 'false';
            }
        }
        if ($key == $selected) {
            $sel = ' selected';
        } else {
            $sel = '';
        }
        $out .= "    <option value=\"$key\"$sel>$value</option>\n";
    }
    $out .= "</select>\n";
    return $out;
}

function baw_date_dropdown() {
    $out = '';
    global $BAW_CURR, $BAW_MES;
    $name ='month';
    $selected = $BAW_CURR['month'];
    $list = $BAW_CURR['months'];
        // 'all' => 'All'
    $out .= baw_generic_dropdown($name, $list, $selected);

    $name = 'year';
    $selected = $BAW_CURR['year'];
    $list = $BAW_CURR['years'];
    $out .= baw_generic_dropdown($name, $list, $selected);
    return $out;
}

function baw_sites_dropdown() {
    global $BAW_CURR;
    if (count($BAW_CURR['sites']) == 1) {
        return $BAW_CURR['sites'][0] . " ";
    }
    $out ="\n<select name=\"site\">\n";
    foreach ($BAW_CURR['sites'] as $site) {
        if ($BAW_CURR['site_name'] == $site) {
            $sel = ' selected';
        } else {
            $sel = '';
        }
        $out .= "    <option value=\"$site\"$sel>$site</option>\n";
    }
    if ($BAW_CURR['site_name'] == 'all_months') {
        $sel = ' selected';
    } else {
        $sel = '';
    }
    $out .= "    <option value=\"all_months\"$sel>All (Monthly)</option>\n";
    if ($BAW_CURR['site_name'] == 'all_days') {
        $sel = ' selected';
    } else {
        $sel = '';
    }
    $out .= "    <option value=\"all_days\"$sel>All (Daily)</option>\n";
    $out .= "</select>\n";
    return $out;
}
?>