<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'helpers.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

// this function returns the time between the start of the script until now
function baw_ptime() {
    global $BAW_TIME;
    $now = baw_mtime();
    $overall = $now - $BAW_TIME['start'];
    $time_str = number_format($overall, 3). " sec";
    return $time_str;
}

// returns a one-line time report using baw_ptime()
function baw_timereport($str, $always = false) {
    global $BAW_CONF;
    if ($BAW_CONF['show_time'] || $always) {
        return "<div class=\"timereport\">\n    <b>$str: " . baw_ptime() ."</b>\n</div>\n";
    }
}

// calculate the current time in microtime
function baw_mtime() {
    $arr = explode(" ", microtime());
    $out = $arr[0] + $arr[1];
    return $out;
}

// this has to be replaced by a proper time function
// date in format yyyymmdd
function baw_get_date_str($date, $separator) {
    global $BAW_MES;
    $xday = substr($date, 6,2);
    $xmonth = $BAW_MES[59+substr($date, 4,2)];
    $xyear = substr($date,0,4);
    return "$xday$separator$xmonth$separator$xyear";
}

function baw_byte_format($number, $decimals = 2) {
    global $BAW_CONF;
    // kilo, mega, giga, tera, peta, exa, zetta, yotta
    $prefix_arr = array('','k','M','G','T','P','E','Z','Y');
    $i = 0;
    if ($number == 0) {
        $result = 0;
    } else {
        $value = round($number, $decimals);
        while ($value > 1024) {
            $value /= 1024;
            $i++;
        }
        $result = number_format($value, $decimals, $BAW_CONF['dec_point'], $BAW_CONF['tho_point']);
    }
    $result .= ' '.$prefix_arr[$i].'B';
    return $result;
}

function baw_empty_format($str = '') {
    if (strlen($str) > 0) {
        return $str;
    } else {
        return '&nbsp;';
    }
}

function baw_num_format($number, $decimals = 0) {
    global $BAW_CONF;
    if ($number == 0 || empty($number) || !isset($number)) {
        $result = '0';
    } else {
        $result = number_format($number, $decimals, $BAW_CONF['dec_point'], $BAW_CONF['tho_point']);
    }
    return $result;
}

function baw_getdate_format($str) {
    $out = date("d-M-Y", baw_get_timestamp($str));
    return $out;
}

function baw_time_format($str) {
    $str = date("d-M-Y - H:i", baw_get_timestamp($str));
    return $str;
}

function baw_get_timestamp($str) {
    $year = substr($str, 0, 4);
    $month = substr($str, 4, 2);
    $day = substr($str, 6,2);
    $hour = substr($str, 8,2);
    $minute = substr($str, 10,2);
    $second = substr($str, 12,2);
    settype($year, "int");
    settype($month, "int");
    settype($day, "int");
    settype($hour, "int");
    settype($minute, "int");
    settype($second, "int");
    $timestamp = mktime ($hour, $minute, $second, $month, $day, $year);
    return $timestamp;
}


function baw_percent_format($number) {
    global $BAW_CONF;
    $result = number_format(
        $number,
        $BAW_CONF['percent_decimals'],
        $BAW_CONF['dec_point'],
        $BAW_CONF['tho_point']
    ) . " %";
    return $result;
}

//Slice an array but keep numeric keys
function baw_cut_array($array, $offset) {
    $a = 0;
    $output_array = array();
    foreach ($array as $key => $value) {
        if ($a >= $offset) {
            $output_array[$key] = $value;
        }
        $a++;
    }
    return $output_array;
}

//Slice an array but keep numeric keys
function baw_cut_date_array($array, $day) {
    $output_array = array();
    foreach ($array as $key => $value) {
        if ($key > $day) {
            $output_array[$key] = $value;
        }
    }
    return $output_array;
}

function baw_array_sorting($data, $column, $order = SORT_DESC) {
    if (count($data) ==0) {
        return $data;
    }
    foreach ($data as $description => $numbers) {
        $sort_col[$description] = @$numbers[$column];
    }
    array_multisort($sort_col, $order, $data);
    return $data;
}

function baw_set_language() {
    global $BAW_CONF;
    // remove trailing slash if exists
    if (substr($BAW_CONF['path_lang'], -1) == '/') {
        $BAW_CONF['path_lang'] = substr($BAW_CONF['path_lang'], 0, strlen($BAW_CONF['path_lang']) - 1);
    }

    if ($BAW_CONF['lang_setting'] == 'auto') {
        $lang = baw_detect_language($BAW_CONF['path_lang']);
    } else {
        $lang = $BAW_CONF['lang_setting'];
    }
    $BAW_CONF['lang'] = $lang;
    $path = $BAW_CONF['path_lang']."/awstats-{$lang}.txt";
    if (!file_exists($path)) {
        echo baw_raise_error('languagefile', array($path));
        $message = false;
    } else {
        $message = baw_read_lng_data($path);
    }

    if (!$message) {
        echo "language file could not be read! File: {$BAW_CONF['path_lang']}/awstats-{$BAW_CONF['lang']}.txt";
        $message = false;
    }
    return $message;
}

function baw_detect_language($dirlang) {
    global $BAW_CONF;
    $lang = '';
    if ($BAW_CONF['debug']) {
        echo "<hr>trying to detect language<br>";
    }
    $acc_lang = explode(',', @$_SERVER['HTTP_ACCEPT_LANGUAGE']);
    foreach ($acc_lang as $lang) {
        $lang = strtolower(substr($lang, 0, 2));
        if (file_exists("$dirlang/awstats-$lang.txt")) {
            break;
        } else {
            $lang = '';
        }
    }
    if (!$lang) {
        $lang = 'en';
    }
    if ($BAW_CONF['debug']) {
        echo " detectd language: $lang<hr>";
    }
    return $lang;
}

function baw_raise_error($type, $data = array()) {
    global $BAW_LIB, $BAW_CONF;

    $cd = count($data);
    if ($cd == 0) {
        $out = $BAW_LIB['errors'][$type];
    } else if ($cd == 1) {
        $out = sprintf($BAW_LIB['errors'][$type], $data[0]);
    } else if ($cd == 2) {
        $out = sprintf($BAW_LIB['errors'][$type], $data[0], $data[1]);
    } else if ($cd == 3) {
        $out = sprintf($BAW_LIB['errors'][$type], $data[0], $data[1], $data[2]);
    }
    // this is here in case the error comes so early that display helpers was not included yet.
    if ($BAW_CONF['module'] == 'drupal') {
        drupal_set_message(t($out));
    } else {
        include_once('./core/display_helpers.php');
        $out = baw_site_header() . "<div class=\"errorbox\"><h1>BetterAWstats Error</h1>$out</div></body></html>";
        return $out;
    }
}


?>