<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'render_htmlchart.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

function baw_render_htmlchart($chart, $get_avg, $top_x) {
    global $BAW_CONF, $BAW_LIB, $BAW_MES;
    $out = '';
    // find out max values
    $max = array();
    $avg = array();
    $sum = array();
    $count_val = count($chart);
    if ($count_val > 12) {
        $width = 4;
    } else {
        $width = 6;
    }
    // get maximum values for scaling
    $count_up = 0;
    $rowsum = 0;
    $count_val_static = $count_val;
    foreach ($chart as $lineid => $row) { // get the first set of data (one month/day/etc)
        $count_val--; // this is used to find the final line
        if (!$top_x or $count_up < $top_x) {
            foreach ($row as $cell => $attr) { // iterate through all the different data of one set
                $data = $attr['data'];
                // $out .= "{$attr['format']}: max({$max[$attr['format']]}, $data)";
                @$max[$attr['format']] = max(@$max[$attr['format']], $data);
                // $out .= " = {$max[$attr['format']]}<br>";
                if ($get_avg) {
                    // add avg to charts
                    @$sum[$attr['format']] += $data;
                    if ($count_val >= 0) { // sum all values of this row
                        $rowsum += $data;
                    }
                    if ($count_val == 0) { // do this only for the last value
                        if (!$BAW_CONF['avg_zero'] && $rowsum == 0) { // do this here again for the last row
                            $count_val_static--;
                        }
                        @$avg[$attr['format']] = $sum[$attr['format']] / $count_val_static;
                        // adding averages to the end of the data
                        $chart[$BAW_MES[96]][] = array(
                            'data'=> $avg[$attr['format']],
                            'format' => $attr['format']
                        );
                    }
                }
            }
            if (!$BAW_CONF['avg_zero'] && $rowsum == 0) { // substract line if all values zero
                $count_val_static--;
            }
        }
        $count_up++;
    }
    // create actual chart
    $legend = '';
    $out .= "\n<table class=\"charttable\">\n";
    $out .= "    <tr>\n";
    $c = 0;
    foreach ($chart as $lineid => $row) {
        if (!$top_x or $c < $top_x) {
            $out .= "        <td class=\"chartcell\">\n";
            foreach ($row as $cell => $attr) {
                $tags = '';
                // create attributes
                foreach ($attr as $name => $value){
                    if ($name == 'data') {
                        $data = $value;
                    } else if ($name != 'format') {
                        $tags .= " $name=\"$value\"";
                    }
                }
                $format = $BAW_LIB['formats'][$attr['format']];
                $function = $format['frm'];
                $alt = "{$BAW_MES[$format['txt']]}: ". $function($data);
                // insert here the scaling figure
                $max_string = str_replace('layout_', '', $attr['format']);
                $max_val_field = $BAW_CONF["max_$max_string"];
                if ((isset($max[$max_val_field])) && ($max[$max_val_field]>0)) {
                    $height = $data / ($max[$max_val_field] / 100); //( / ) * 100;
                } else {
                    $height = 1;
                }
                if ($height < 1) {
                    $height = 1;
                }
                $attr = array(
                    'height'=> $height,
                    'width' => $width,
                    'alt' => $alt,
                    'title' => $alt,
                    'class' => 'chartimg'
                );
                $out .= baw_create_image($BAW_CONF['icons_url'] . "/other/{$format['img']}", $attr);
            }
            $out .= "\n        </td>\n";
            $legend_arr = explode("<br>",$lineid);
            if (!isset($legendcount)) {
                $legendcount = count($legend_arr);
            }
            $f = 1;
            for ($i=0; $i<$legendcount; $i++) {
                if ($i > 0) {
                   $tags = '';
                }
                    @$legend[$i][$c] ="        <td$tags colspan=\"1\">{$legend_arr[$i]}</td>\n";
                if (isset($legend[$i][$c-1]) && isset($legend_arr[$i])) {
                    $f ++;
                    if (preg_match('#colspan=\\"(\d+)\\">'. $legend_arr[$i].'</td>#', $legend[$i][$c-1], $number)) {
                        $number[1]++;
                        @$legend[$i][$c] ="        <td$tags colspan=\"{$number[1]}\">{$legend_arr[$i]}</td>\n";
                        $legend[$i][$c-1] ="";
                    }
                } else {
                    $f = 1;
                }
            }
        }
        $c ++;
    }
    if ($top_x and $c > $top_x) {
        $c = $top_x;
    }
    $out .= "    </tr>\n";
    // Display legend
    if (!isset($legendcount)) {
        $legendcount = 0;
    }
    for ($i=0; $i<$legendcount; $i++) {
        $out .= "    <tr class=\"chartlegend\">\n";
        for ($j=0; $j<$c; $j++) {
            $out .= $legend[$i][$j];
        }
        $out .= "    </tr>\n";
    }
    $out .= "</table>\n";
    return $out;
}
?>