<?php
/**
 * betterawstats - an alternative display for awstats data
 *
 * @author      Oliver Spiesshofer, oliver at spiesshofer dot com
 * @copyright   2007 Oliver Spiesshofer
 * @version     0.13
 * @link        http://tokyoahead.com/main/staticpages/index.php/betterawstats

 * Based on the GPL AWStats Totals script by:
 * Jeroen de Jong <jeroen@telartis.nl>
 * copyright   2004-2006 Telartis
 * version 1.13 (http://www.telartis.nl/xcms/awstats)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// this file can't be used on its own
if (strpos ($_SERVER['PHP_SELF'], 'reder_table.inc.php') !== false) {
    die ('This file can not be used on its own!');
}

function baw_render_table($section_name, $table, $format, $get_avg = false, $get_sum = false,
                      $top_x = false, $dataformat = false) {
    global $BAW_CONF, $BAW_LIB, $BAW_MES, $BAW_CONF_DIS;
    $out = '';
    $out .= "\n<table class=\"datatable\">\n";

    // HEADER -----------------------------------------------------------------
    $out .= "    <tr>\n";
    $format_arr = array();
    $column = 0;
    if ($top_x == false) {
        $top_x == $BAW_CONF['maxlines'];
    }
    $itemcount = count($table);
    foreach ($format as $cell => $attr) {
        $class = '';
        $tags ='';
        $percent_header = '';
        $sorticon = '';
        $isnumber = false;

        if (isset($BAW_CONF_DIS[$section_name]['sort']) && ($BAW_CONF_DIS[$section_name]['sort'] == $column)) {
            $sorticonurl = $BAW_CONF['site_url'] . "/icons/expand.gif";
            $sorticon = "&nbsp;<a href=\"\">" . baw_create_image($sorticonurl) . "</a>";
        } else {
            $sorticon = '';
        }
        foreach ($attr as $name => $value){
            if (strlen($value)>0) {
                if ($name == 'title') {
                    $data = $value;
                } else if ($name == 'format') {
                    $format_arr[] = $value;
                    $class_arr[] = $value;
                    $class = " class=\"$value\"";
                    if ($value !== 'layout_text') {
                        $isnumber = true;
                    }
                // do nothing with percentage indicators
                } else if ($name == 'percent' && $value == true){
                    $percent_header = "        <th class=\"layout_percent\">{$BAW_MES[15]}$sorticon</th>\n";
                } else {
                    $tags .= " $name=\"$value\"";
                }
            }
        }
        $count_str = '';
        if ($column == 0) {
            $count_str = baw_num_format($itemcount) . " ";
        }
        if ($isnumber) {
        //    $percenticon = "<span onClick=\"toggleRow('col_{$section_name}_$column');\" class=\"percent_button\">P</span>";
        } else {
            $percenticon = '';
        }
        if (isset($attr['title'])) {
            $out .="        <th$tags$class><div class=\"header_wrap\">$count_str$data$sorticon</div></th>\n$percent_header";
        }
        $column ++;
    }
    $out .= "    </tr>\n";

    // SUM ---------------------------------------------------------------------
    $sum_arr = array();
    foreach ($table as $lineid => $row) {
        $cell_no = 0;
        foreach ($row as $cell) {
            if (!isset($sum_arr[$cell_no])) {
                $sum_arr[$cell_no] = 0;
            }
            if (is_numeric($cell)) {
                $sum_arr[$cell_no] += $cell;
            } else {
                $sum_arr[$cell_no] = '';
            }
            $cell_no ++;
        }
    }
    // DATA --------------------------------------------------------------------
    $count_rows = count($table);
    $sumstr = '';
    $avgstr = '';
    $others = array();
    $hasothers = false;
    $numrow = -1; // one additional for first line
    $othercount = 0;
    $rowsum = 0;
    foreach ($table as $lineid => $row) {
        if (!$top_x or ($numrow+1) < $top_x) {
            $class = '';
            if (isset($dataformat[$lineid])) {
                $class = " class=\"{$dataformat[$lineid]}\"";
            }
            $out .= "    <tr$class>\n";
            $cell_no = 0;
            foreach ($row as $cell) {
                @$sum[$cell_no]['data'] += $cell;
                if ($get_avg && is_numeric($cell)) {
                    $rowsum += $cell;
                }
                $function = @$BAW_LIB['formats'][$format_arr[$cell_no]]['frm'];
                $cell_str = $cell;
                if (isset($function) && function_exists($function)) {
                    $cell_str = $function($cell);
                }
                unset($function);
                $class = '';
                if (isset($class_arr[$cell_no]) && strlen($class_arr[$cell_no]) > 0) {
                    $class = " class=\"{$class_arr[$cell_no]}\"";
                }
                if (substr($cell_str, 0, 1) !== "<" && strlen($cell_str) > $BAW_CONF['field_length']) {
                    $cell_str = substr($cell_str, 0, $BAW_CONF['field_length']-3) . "...";
                }
                $out .="        <td$class>$cell_str</td>\n";
                if (isset($format[$cell_no]['percent']) && $format[$cell_no]['percent'] == true) {
                    $percent = @baw_percent_format($cell / ($sum_arr[$cell_no] / 100));
                    $out .="        <td$class>$percent</td>\n";
                }
                $cell_no ++;
            }
            if (!$BAW_CONF['avg_zero'] && $rowsum == 0) {
                $count_rows--;
            }
            $out .= "    </tr>\n";
            $numrow++;
        } else { // top_x
            $cell_no = 0;
            $hasothers = true;
            $othercount ++;
            foreach ($row as $cell) {
                if (is_numeric($cell)) {
                    if (!isset($others[$cell_no])) {
                        $others[$cell_no] = 0;
                    }
                    $others[$cell_no] += $cell;
                    if ($get_avg) {
                        $rowsum += $cell;
                    }
                } else {
                    if (!isset($others[$cell_no])) {
                        $others[$cell_no] = '';
                    }
                }
                $cell_no ++;
            }
            if (!$BAW_CONF['avg_zero'] && $rowsum == 0) {
                $count_rows--;
            }
        }
    }
    // "Others" ----------------------------------------------------------------
    if ($top_x && $hasothers) {
        $others[0] = baw_display_full_list_link ($section_name, $BAW_MES[2], false)
                ." (". baw_num_format($othercount) . ")";
        $out .= "    <tr class=\"others\">\n";
        $cell_no = 0;
        $attr = '';
        $iteration = 0;
        foreach ($others as $otherfield) {
            $span = 0;
            $attr = '';
            if ($cell_no > $iteration) {
                $iteration ++;
                continue;
            }
            if (isset($format[$cell_no]['colspan'])) {
                $span = $format[$cell_no]['colspan'];
                $attr = " colspan=\"$span\"";
                $span --;
                $cell_no += $span;
            }
            $function = @$BAW_LIB['formats'][$format_arr[$cell_no]]['frm'];
            if (isset($function) && function_exists($function)) {
                $cell_str = $function($otherfield);
            }
            $format_test = $format_arr[$cell_no];
            if ($format_arr[$cell_no] == 'layout_date') {
                $cell_str = '&nbsp;';
            }
            unset($function);
            $class = '';
            if (isset($class_arr[$cell_no]) && strlen($class_arr[$cell_no]) > 0) {
                $class = " class=\"{$class_arr[$cell_no]}\"";
            }
            $out .="        <td$attr$class>$cell_str</td>\n";
            if (isset($format[$cell_no]['percent']) && $format[$cell_no]['percent'] == true) {
                $percent = @baw_percent_format($otherfield / ($sum_arr[$cell_no] / 100));
                $out .="        <td$class>$percent</td>\n";
            }
            $cell_no++;
            $iteration ++;
        }
        $out .= "    </tr>\n";
    }

    // SUM & AVG ---------------------------------------------------------------
    if ($get_sum or $get_avg) {
        $cell_no = 0;
        foreach ($sum_arr as $sumvalue) {
            $sumformat = $format[$cell_no]['format'];
            if ($cell_no == 0) {
                $avgstr .= "        <td class=\"layout_text\">{$BAW_MES[96]}</td>\n";
                $sumstr .= "        <td class=\"layout_text\">{$BAW_MES[102]}</td>\n";
            } else {
                @$avgvalue = $sumvalue / ($count_rows);
                $function = @$BAW_LIB['formats'][$sumformat]['frm'];
                $sumvalue_str = '';
                $avgvalue_str = '';
                if (isset($function) && function_exists($function)) {
                    $sumvalue_str = $function($sumvalue);
                    $avgvalue_str = $function($avgvalue);
                }
                if ($format_arr[$cell_no] == 'layout_date') {
                    $sumvalue_str = '&nbsp;';
                    $avgvalue_str = '&nbsp;';
                }
                $sumstr .= "        <td class=\"$sumformat\">$sumvalue_str</td>\n";
                $avgstr .= "        <td class=\"$sumformat\">$avgvalue_str</td>\n";
                if (isset($format[$cell_no]['percent']) && $format[$cell_no]['percent'] == true) {
                    $percent = @baw_percent_format($sumvalue / ($sum_arr[$cell_no] / 100));
                    $sumstr .="        <td class=\"$sumformat\">$percent</td>\n";
                    $avgstr .="        <td class=\"$sumformat\"></td>\n";
                }
            }
            $cell_no ++;
        }
        if ($get_avg) {
            $out .= "    <tr class=\"layout_avg\">\n$avgstr\n    </tr>\n";
        }
        if ($get_sum) {
            $out .= "    <tr class=\"layout_sum\">\n$sumstr\n    </tr>\n";
        }
    }
    $out .= "</table>\n";
    return $out;
}

?>