var BBC_CTRL = false;
var BBC_SHFT = false;
var BBC_SEL_TEXT = '';
var BBC_SEL_USER = '';

Drupal.bbcodeAutoAttach = function() {
  var out = '', settings = Drupal.settings.bbcode_wysiwyg;
  out += '<div class="bbcode_wysiwyg">';
  for(var button in settings.buttons) {
    var charcode = settings.buttons[button];
    if (charcode) {
      out += '<input type="button" class="bbcode-'+ button +'" value="'+ button +'" title="CTRL + SHIFT + '+ String.fromCharCode(charcode).toUpperCase() +'" />';
    }
  }
  out += '</div>';
  
  /**
   * Attach events:
   */
  // Button clicks
  $('label[@for="' + settings.attachTo +'"]').before(out);
  $('.bbcode_wysiwyg input').click(function() {
    Drupal.bbcodeClick($(this).attr('value'));
  });
  // Keyup / Keydown - detect hotkeys
  $('#'+ settings.attachTo).keydown(function(event) {
    Drupal.bbcodeKeydown(event.keyCode);
  });
  $('#'+ settings.attachTo).keyup(function(event) {
    Drupal.bbcodeKeyup(event.keyCode);
  });
  // Mouseup - store current quoted user
  $('.node').mouseup(function(event) {
    BBC_SEL_TEXT = Drupal.bbcodeGetDomSelection();
    var node = $(event.target).parents('.node')[0];
    if (BBC_SEL_TEXT) {
      BBC_SEL_USER = $('.bbcode-username', node).text();
    }
    else {
      BBC_SEL_USER = '';
    }
  });
  $('.comment').mouseup(function(event) {
    BBC_SEL_TEXT = Drupal.bbcodeGetDomSelection();
    var comment = $(event.target).parents('.comment')[0];
    if (BBC_SEL_TEXT) {
      BBC_SEL_USER = $('.bbcode-username', comment).text();
    }
    else {
      BBC_SEL_USER = '';
    }
  });
}


Drupal.bbcodeClick = function(button) {
  var settings = Drupal.settings.bbcode_wysiwyg;
  var open = Drupal.settings.bbcode_wysiwyg.openTags[button];
  var selection = Drupal.bbcodeGetTextareaSelection();
  var before = '';
  var after = '';
  
  // Bold
  if (button == 'bold') {
    before = '[b]';
    after = '[/b]';
  }
  
  // Italic
  if (button == 'italic') {
    before = '[i]';
    after = '[/i]';
  }
  
  // Quote
  if (button == 'quote') {
    before = '[quote='+ BBC_SEL_USER +']';
    if (BBC_SEL_TEXT) {
      before += BBC_SEL_TEXT;
    }
    after = '[/quote]';
  }
  
  // Link
  if (button == 'link') {
    var enterURL   = prompt(settings.enterLinkURL, "http://");
    var foundErrors = '';
    if (!enterURL || enterURL == 'http://')    {
      foundErrors = settings.enterLinkURL;
    }
    if (foundErrors)  {
      alert(foundErrors);
      return;
    }
    before = '[url=' + enterURL + ']';
    after = '[/url]';
  }
  
  // Image
  if (button == 'image') {
    before = '[img]';
    after = '[/img]';
    if (!selection) {
      var enterURL = prompt(settings.enterImageURL, "http://");
      var foundErrors = '';
      if (!enterURL || enterURL == 'http://')    {
        foundErrors = settings.enterLinkURL;
      }
      if (foundErrors)  {
        alert(foundErrors);
        return;
      }
      before = '[img]' + enterURL;
    }
  }
  
  // Break
  if (button == 'break') {
    after = '<!--break-->';
  }
  
  // Center
  if (button == 'center') {
    before = '[center]';
    after = '[/center]';
  }
  
  Drupal.settings.bbcode_wysiwyg.openTags[button] = !open;
  Drupal.bbcodeWrapSelection(before, after, selection);
}


Drupal.bbcodeWrapSelection = function(before, after, selection) {
  var settings = Drupal.settings.bbcode_wysiwyg;
  var area = $('#' + settings.attachTo)[0];
  var caretPos = null;
  var value = before + selection + after;
  Drupal.bbcodeInsertAtCursor(area, value);
  area.focus();
}


Drupal.bbcodeGetTextareaSelection = function() {
  var text = null, settings = Drupal.settings.bbcode_wysiwyg;
  var area = $('#' + settings.attachTo)[0];
  // Firefox
  if (area.selectionStart || area.selectionStart == '0') {
    text = area.value.substr(area.selectionStart, area.selectionEnd - area.selectionStart);
  }
  // IE
  else if (document.selection && document.selection.createRange) {
    var range = document.selection.createRange();
    text = range.text;
  }
  return text;
}


Drupal.bbcodeQuoteLink = function(username, body) {
  var area = $('#' + Drupal.settings.bbcode_wysiwyg.attachTo)[0]; 
  Drupal.bbcodeInsertAtCursor(area, '[quote='+ username +']'+ body +'[/quote]'); 
  area.focus();
}


Drupal.bbcodeGetDomSelection = function() {
  var txt = '';
  if (window.getSelection) {
    var selection = window.getSelection();
    txt = selection.toString();
  }
  else if (document.getSelection) {
    txt = document.getSelection();
  }
  else if (document.selection) {
    txt = document.selection.createRange().text;
  }
  return txt;
}


Drupal.bbcodeInsertAtCursor = function(field, value) {
  //MOZILLA/NETSCAPE support
  if (field.selectionStart || field.selectionStart == '0') {
    var startPos = field.selectionStart;
    var endPos = field.selectionEnd;
    field.value = field.value.substring(0, startPos)
      + value
      + field.value.substring(endPos, field.value.length);
    field.selectionStart = startPos + value.length;
    field.selectionEnd = endPos + value.length;
  }
  //IE support
  else if (document.selection) {
    field.focus();
    sel = document.selection.createRange();
    sel.text = value;
  }
}


Drupal.bbcodeKeydown = function(keycode) {
  var settings = Drupal.settings.bbcode_wysiwyg;
  
  // shift
  if (keycode == 16) {
    BBC_SHFT = true;
  }
  
  // ctrl
  if (keycode == 17) {
    BBC_CTRL = true;
  }
  
  if (BBC_CTRL && BBC_SHFT) {
    for (var button in settings.buttons) {
      if (keycode == settings.buttons[button]) {
        Drupal.bbcodeClick(button);
        BBC_CTRL = false;
        BBC_SHFT = false;
        break;
      }
    }
  }
}


Drupal.bbcodeKeyup = function(keycode){
  // shift
  if (keycode == 16) {
    BBC_SHFT = false;
  }
  
  // ctrl
  if (keycode == 17) {
    BBC_CTRL = false;
  }
}


if (Drupal.jsEnabled) {
  $(document).ready(Drupal.bbcodeAutoAttach);
}