<?php
/**
 * @file
 * Provides Drupal\bcs\BCSBase.
 */

namespace Drupal\bcs;

use Drupal\Core\Database\Database;

class BCSBase {

  /**
   * Load list view modes
   * @return array
   */
  public static function bcs_loadViewModes() {
    $view_modes = array();

    $entity_info = \Drupal::entityManager()->getViewModes('node');
    if (!empty($entity_info)) {
      foreach ($entity_info as $k => $v) {

        $view_modes[$k] = $v['label'];
      }
    }

    return $view_modes;
  }

  /**
   * Save data block
   * @param $id_block
   * @param $items
   * @throws \Exception
   */
  public static function bcs_save_data_block($id_block, $items) {
    $user = \Drupal::currentUser();

    $block = self::bcs_load_data_block($id_block);

    $fields = array(
      'uid' => $user->id(),
      'id_block' => $id_block,
      'data' => @serialize($items),
      'status' => 1,
      'created' => REQUEST_TIME,
    );

    if ($block) {
      // Update data block
      db_update('bcs_data')
        ->fields($fields)
        ->condition('id_block', $id_block)
        ->execute();

    } else {
      // Insert data block
      Database::getConnection()
        ->insert('bcs_data')
        ->fields($fields)
        ->execute();
    }
  }

  /**
   * Load data block by id block
   * @param $id_block
   * @return mixed
   */
  public static function bcs_load_data_block($id_block) {
    $result = db_select('bcs_data', 't')
      ->fields('t')
      ->condition('t.id_block', $id_block, '=')
      ->execute()
      ->fetchObject();

    return $result;
  }

  /**
   * Load node view by id and mode view
   * @param $nid
   * @param string $mode_view
   * @return array
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   */
  public static function bcs_load_node_view($nid, $mode_view = 'teaser') {
    $entity = \Drupal::entityManager()
      ->getStorage('node')
      ->load($nid);

    $node_view = \Drupal::getContainer()
      ->get('entity.manager')
      ->getViewBuilder('node');

    $node_output = $node_view->view($entity, $mode_view);

    return $node_output;
  }

  /**
   * Load list content types
   * @return array
   */
  public static function loadContentTypesList() {
    $contentTypes = \Drupal::service('entity.manager')
      ->getStorage('node_type')
      ->loadMultiple();

    $contentTypesList = [];
    foreach ($contentTypes as $contentType) {
      $contentTypesList[$contentType->id()] = $contentType->label();
    }

    return $contentTypesList;
  }

}
