<?php

namespace Drupal\bcs\Controller;

use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Controller\ControllerBase;

/**
 * Class PageController.
 */
class PageController extends ControllerBase {

  /**
   * @param Request $request
   * @param $type_content
   * @param $limit
   * @return JsonResponse
   */
  public function autocomplete(Request $request, $type_content, $limit)
  {
    $items = [];

    if ($request->get('q')) {
      if (strlen($request->get('q')) > 2) {
        $nodes = $this->searchNodesByType($type_content, $request->get('q') , $limit);

        foreach ($nodes as $node) {
          $items[] = $node->getTitle();

        }
      }
    }

    return new JsonResponse($items);
  }

  /**
   * @param string $type
   * @param $title
   * @param int $limit
   * @return array|\Drupal\Core\Entity\EntityInterface[]|static[]
   */
  public function searchNodesByType($type = 'article', $title, $limit = 10)
  {
    $nodes = [];

    $query = \Drupal::entityQuery('node')
      ->condition('type', [$type, 'page'], 'IN')
      ->condition('title', '%' . db_like($title) . '%', 'LIKE')
      ->condition('status', 1, '=')
      ->range(0, $limit);

    $nids = $query->execute();

    if (!empty($nids)) {
      $nodes = Node::loadMultiple($nids);
    }

    return $nodes;
  }

}
