<?php

/**
 * @file
 * Hooks provided by the BCubed module.
 */

/**
 * Register a bcubed event.
 *
 * @return array
 *   An associative array containing 1 or more event definitions, keyed by ID
 */
function hook_bcubed_event_info() {
  $event = array();

  $event['label'] = 'My Event';

  // Name of library provided by this event (implemented in hook_library())
  $event['library'] = array('module', 'library');

  // Name of JS event to listen for when event is triggered.
  $event['event_name'] = 'myJsEvent';

  // Dictionary definition for registering generated strings (optional)
  $event['generated_strings'] = array(
    array('key' => 'my_fixed_length_string', 'length' => 8),
    array(
      'key' => 'my_random_length_string',
      'length' => array('min' => 4, 'max' => 12),
    ),
  );

  // Name of generated strings dictionary to use (optional - use if not defining own dictionary)
  $event['generated_strings_dictionary'] = 'myDictionary';

  $form = array();

  $form['example'] = array(
    '#type' => 'textfield',
    '#title' => 'Example Setting',
  );

  // Settings form elements for the event. May also be omitted if there are no configurable settings.
  // Alternatively, if the form needs to be dynamically generated this can be set to the generating function name, which will be run when the form is built.
  $event['settings'] = $form;

  // The BCubed plugin dependencies of this event. May be omitted if this event doesn't depend on any other BCubed plugins.
  $event['bcubed_dependencies'] = array(
    array(
      'plugin_type' => 'event',
      'plugin_id' => 'some_event',
      'same_set' => TRUE,
      'dependency_type' => 'requires',
    ),
    array(
      'plugin_type' => 'action',
      'plugin_id' => 'some_action',
      'same_set' => FALSE,
      'dependency_type' => 'generated_by',
    ),
  );

  return array('my_event' => $event);
}

/**
 * Register a bcubed action.
 *
 * @return array
 *   An associative array containing 1 or more action definitions, keyed by ID
 */
function hook_bcubed_action_info() {
  $action = array();

  $action['label'] = 'My Action';

  // Whether the action supports multiple instances per event.
  $action['instances'] = FALSE;

  // Name of library provided by this action (implemented in hook_library())
  $action['library'] = array('module', 'library');

  // Dictionary definition for registering generated strings (optional)
  $action['generated_strings'] = array(
    array('key' => 'my_fixed_length_string', 'length' => 8),
    array(
      'key' => 'my_random_length_string',
      'length' => array('min' => 4, 'max' => 12),
    ),
  );

  // Name of generated strings dictionary to use (optional - use if not defining own dictionary)
  $action['generated_strings_dictionary'] = 'myDictionary';

  $form = array();

  $form['example'] = array(
    '#type' => 'textfield',
    '#title' => 'Example Setting',
  );

  // Settings form elements for the action. May be omitted if there are no configurable settings.
  // Alternatively, if the form needs to be dynamically generated this can be set to the generating function name, which will be run when the form is built.
  $action['settings'] = $form;

  // The BCubed plugin dependencies of this action. May be omitted if this action doesn't depend on any other BCubed plugins.
  $action['bcubed_dependencies'] = array(
    array(
      'plugin_type' => 'event',
      'plugin_id' => 'some_event',
      'same_set' => TRUE,
      'dependency_type' => 'requires',
    ),
  );

  return array('my_action' => $action);
}

/**
 * Register a bcubed condition.
 *
 * @return array
 *   An associative array containing 1 or more condition definitions, keyed by ID
 */
function hook_bcubed_condition_info() {
  $condition = array();

  $condition['label'] = 'My Condition';

  // Whether the condition may be included more than once per condition set.
  $condition['instances'] = FALSE;

  // Name of library provided by this condition (implemented in hook_library(), optional)
  $condition['library'] = array('module', 'library');

  // Dictionary definition for registering generated strings (optional)
  $condition['generated_strings'] = array(
    array('key' => 'my_fixed_length_string', 'length' => 8),
    array(
      'key' => 'my_random_length_string',
      'length' => array('min' => 4, 'max' => 12),
    ),
  );

  // Name of generated strings dictionary to use (optional - use if not defining own dictionary)
  $condition['generated_strings_dictionary'] = 'myDictionary';

  // Global function (PHP) to check before page is loaded.
  // This parameter is optional and can be omitted for conditions which are implemented
  // client-side only (most conditions).
  //
  // @return boolean
  $condition['precondition'] = 'my_precondition_function';

  $form = array();

  $form['example'] = array(
    '#type' => 'textfield',
    '#title' => 'Example Setting',
  );

  // Settings form elements for the condition. May be omitted if there are no configurable settings.
  // Alternatively, if the form needs to be dynamically generated this can be set to the generating function name, which will be run when the form is built.
  $condition['settings'] = $form;

  // The BCubed plugin dependencies of this condition. May be omitted if this action doesn't depend on any other BCubed plugins.
  $condition['bcubed_dependencies'] = array(
    array(
      'plugin_type' => 'event',
      'plugin_id' => 'some_event',
      'same_set' => TRUE,
      'dependency_type' => 'requires',
    ),
  );

  return array('my_condition' => $condition);
}
